/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.comparator;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.local.FileDescriptor;
import ch.cyberduck.core.local.FileDescriptorFactory;
import ch.cyberduck.ui.comparator.BrowserComparator;
import ch.cyberduck.ui.comparator.FilenameComparator;
import java.text.Collator;
import java.util.Locale;

public class FileTypeComparator
extends BrowserComparator {
    private static final long serialVersionUID = 3354482708309574292L;
    private final Collator impl = Collator.getInstance(Locale.getDefault());
    private final FileDescriptor descriptor = FileDescriptorFactory.get();

    public FileTypeComparator(boolean ascending) {
        super(ascending, new FilenameComparator(ascending));
    }

    @Override
    protected int compareFirst(Path p1, Path p2) {
        if (p1.isDirectory() && p2.isDirectory() || p1.isFile() && p2.isFile()) {
            if (this.ascending) {
                return this.impl.compare(this.descriptor.getKind(p1), this.descriptor.getKind(p2));
            }
            return -this.impl.compare(this.descriptor.getKind(p1), this.descriptor.getKind(p2));
        }
        if (p1.isFile()) {
            return this.ascending ? 1 : -1;
        }
        return this.ascending ? -1 : 1;
    }
}

