/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class CreateSymlinkWorker
extends Worker<Path> {
    private static final Logger log = Logger.getLogger(CreateSymlinkWorker.class);
    private final Path link;
    private final String target;

    public CreateSymlinkWorker(Path link, String target) {
        this.link = link;
        this.target = target;
    }

    @Override
    public Path run(Session<?> session) throws BackgroundException {
        Symlink feature = session.getFeature(Symlink.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Run with feature %s", feature));
        }
        feature.symlink(this.link, this.target);
        return this.link;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Uploading {0}", "Status"), this.link.getName());
    }
}

