/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.vault.DefaultVaultRegistry;
import ch.cyberduck.core.vault.VaultUnlockCancelException;

public class VaultRegistryUrlProvider
implements UrlProvider {
    private final Session<?> session;
    private final UrlProvider proxy;
    private final DefaultVaultRegistry registry;

    public VaultRegistryUrlProvider(Session<?> session, UrlProvider proxy, DefaultVaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public DescriptiveUrlBag toUrl(Path file) {
        try {
            return this.registry.find(this.session, file, false).getFeature(this.session, UrlProvider.class, this.proxy).toUrl(file);
        }
        catch (VaultUnlockCancelException e) {
            return this.proxy.toUrl(file);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryUrlProvider{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

