/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.RegistryBackgroundAction;
import ch.cyberduck.core.worker.Worker;
import java.util.Objects;
import org.apache.log4j.Logger;

public class WorkerBackgroundAction<T>
extends RegistryBackgroundAction<T> {
    private static final Logger log = Logger.getLogger(WorkerBackgroundAction.class);
    protected final Worker<T> worker;
    protected T result;

    public WorkerBackgroundAction(Controller controller, SessionPool session, Worker<T> worker) {
        super(controller, session);
        this.worker = worker;
    }

    public WorkerBackgroundAction(Controller controller, SessionPool session, Worker<T> worker, ProgressListener progress) {
        super(controller, session, progress);
        this.worker = worker;
    }

    public WorkerBackgroundAction(Controller controller, SessionPool session, Worker<T> worker, ProgressListener progress, AlertCallback alert, LoginCallback login) {
        super(controller, session, progress, alert, login);
        this.worker = worker;
    }

    @Override
    protected void reset() throws BackgroundException {
        this.worker.reset();
        super.reset();
    }

    @Override
    public T run(Session<?> session) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Run worker %s", this.worker));
        }
        try {
            this.result = this.worker.run(session);
        }
        catch (ConnectionCanceledException e) {
            this.worker.cancel();
            throw e;
        }
        return this.result;
    }

    @Override
    public void cleanup() {
        if (null == this.result) {
            log.warn((Object)String.format("Missing result for worker %s. Use default value.", this.worker));
            this.worker.cleanup(this.worker.initialize());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Cleanup worker %s", this.worker));
            }
            this.worker.cleanup(this.result);
        }
        super.cleanup();
    }

    @Override
    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Cancel worker %s", this.worker));
        }
        this.worker.cancel();
        super.cancel();
    }

    @Override
    public boolean isCanceled() {
        return this.worker.isCanceled();
    }

    @Override
    public String getActivity() {
        return this.worker.getActivity();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerBackgroundAction that = (WorkerBackgroundAction)o;
        return Objects.equals(this.worker, that.worker);
    }

    public int hashCode() {
        return this.worker != null ? this.worker.hashCode() : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WorkerBackgroundAction{");
        sb.append("worker=").append(this.worker);
        sb.append('}');
        return sb.toString();
    }
}

