/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.LoginCallbackFactory;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.TransferErrorCallbackControllerFactory;
import ch.cyberduck.core.TransferPromptControllerFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.DisabledStreamListener;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.threading.ScheduledThreadPool;
import ch.cyberduck.core.threading.TransferWorkerBackgroundAction;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import ch.cyberduck.core.transfer.TransferListener;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferSpeedometer;
import ch.cyberduck.core.worker.ConcurrentTransferWorker;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TransferBackgroundAction
extends TransferWorkerBackgroundAction<Boolean> {
    private final Transfer transfer;
    private final TransferOptions options;
    private final TransferSpeedometer meter;
    private ScheduledFuture progressTimer;
    private ScheduledThreadPool timerPool;
    private final TransferListener listener;
    private final TransferPrompt prompt;

    public TransferBackgroundAction(Controller controller, SessionPool source, SessionPool destination, TransferListener listener, Transfer transfer, TransferOptions options) {
        this(controller, source, destination, listener, controller, transfer, options, TransferPromptControllerFactory.get(controller, transfer, source, destination), TransferErrorCallbackControllerFactory.get(controller), new TransferSpeedometer(transfer), new DisabledStreamListener());
    }

    public TransferBackgroundAction(Controller controller, SessionPool source, SessionPool destination, TransferListener listener, ProgressListener progress, Transfer transfer, TransferOptions options) {
        this(controller, source, destination, listener, progress, transfer, options, TransferPromptControllerFactory.get(controller, transfer, source, destination), TransferErrorCallbackControllerFactory.get(controller));
    }

    public TransferBackgroundAction(Controller controller, SessionPool source, SessionPool destination, TransferListener listener, ProgressListener progress, Transfer transfer, TransferOptions options, TransferPrompt prompt) {
        this(controller, source, destination, listener, progress, transfer, options, prompt, TransferErrorCallbackControllerFactory.get(controller), new TransferSpeedometer(transfer), new DisabledStreamListener());
    }

    public TransferBackgroundAction(Controller controller, SessionPool source, SessionPool destination, TransferListener listener, ProgressListener progress, Transfer transfer, TransferOptions options, TransferPrompt prompt, TransferErrorCallback error) {
        this(controller, source, destination, listener, progress, transfer, options, prompt, error, new TransferSpeedometer(transfer), new DisabledStreamListener());
    }

    public TransferBackgroundAction(Controller controller, SessionPool source, SessionPool destination, TransferListener listener, ProgressListener progress, Transfer transfer, TransferOptions options, TransferPrompt prompt, TransferErrorCallback error, TransferSpeedometer meter, StreamListener stream) {
        this(LoginCallbackFactory.get(controller), controller, source, destination, listener, progress, transfer, options, prompt, error, meter, stream);
    }

    public TransferBackgroundAction(ConnectionCallback callback, Controller controller, SessionPool source, SessionPool destination, TransferListener listener, ProgressListener progress, Transfer transfer, TransferOptions options, TransferPrompt prompt, TransferErrorCallback error, TransferSpeedometer meter, StreamListener stream) {
        super(controller, source, new ConcurrentTransferWorker(source, destination, transfer, options, meter, prompt, error, callback, progress, stream, NotificationServiceFactory.get()));
        this.options = options;
        this.meter = meter;
        this.transfer = transfer;
        this.listener = listener;
        this.prompt = prompt;
    }

    @Override
    public void prepare() {
        super.prepare();
        this.transfer.start();
        this.listener.transferDidStart(this.transfer);
        this.timerPool = new ScheduledThreadPool();
        this.progressTimer = this.timerPool.repeat(new Runnable(){

            @Override
            public void run() {
                if (TransferBackgroundAction.this.transfer.isReset()) {
                    TransferBackgroundAction.this.listener.transferDidProgress(TransferBackgroundAction.this.transfer, TransferBackgroundAction.this.meter.getStatus());
                }
            }
        }, 100L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean alert(BackgroundException e) {
        if (super.alert(e)) {
            this.options.reloadRequested = false;
            this.options.resumeRequested = true;
            return true;
        }
        return false;
    }

    @Override
    public void message(String message) {
        super.message(message);
        this.prompt.message(message);
    }

    @Override
    public void finish() {
        super.finish();
        this.progressTimer.cancel(false);
        this.transfer.stop();
        this.listener.transferDidStop(this.transfer);
        this.timerPool.shutdown();
    }

    @Override
    public String getActivity() {
        return this.transfer.getName();
    }

    public TransferSpeedometer getMeter() {
        return this.meter;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }
}

