/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.threading.ThreadPool;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class ThreadPoolFactory
extends Factory<ThreadPool> {
    private static final Logger log = Logger.getLogger(ThreadPoolFactory.class);

    public ThreadPoolFactory() {
        super("factory.threadpool.class");
    }

    protected ThreadPool create(String prefix, Integer size, ThreadPool.Priority priority, BlockingQueue<Runnable> queue, Thread.UncaughtExceptionHandler handler) {
        try {
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{prefix.getClass(), size.getClass(), ((Object)((Object)priority)).getClass(), queue.getClass(), handler.getClass()});
            if (null == constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", handler.getClass()));
                return (ThreadPool)this.clazz.newInstance();
            }
            return (ThreadPool)constructor.newInstance(new Object[]{prefix, size, priority, queue, handler});
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new FactoryException(e.getMessage(), e);
        }
    }

    public static ThreadPool get() {
        return ThreadPoolFactory.get(new LoggingUncaughtExceptionHandler());
    }

    public static ThreadPool get(Thread.UncaughtExceptionHandler handler) {
        return ThreadPoolFactory.get("background", PreferencesFactory.get().getInteger("threading.pool.size.max"), handler);
    }

    public static ThreadPool get(String prefix, Thread.UncaughtExceptionHandler handler) {
        return ThreadPoolFactory.get(prefix, PreferencesFactory.get().getInteger("threading.pool.size.max"), handler);
    }

    public static ThreadPool get(int size) {
        return ThreadPoolFactory.get("background", size);
    }

    public static ThreadPool get(int size, Thread.UncaughtExceptionHandler handler) {
        return ThreadPoolFactory.get("background", size, handler);
    }

    public static ThreadPool get(String prefix, int size) {
        return ThreadPoolFactory.get(prefix, size, ThreadPool.Priority.norm);
    }

    public static ThreadPool get(String prefix, ThreadPool.Priority priority) {
        return ThreadPoolFactory.get(prefix, PreferencesFactory.get().getInteger("threading.pool.size.max"), priority);
    }

    public static ThreadPool get(String prefix, ThreadPool.Priority priority, Thread.UncaughtExceptionHandler handler) {
        return ThreadPoolFactory.get(prefix, PreferencesFactory.get().getInteger("threading.pool.size.max"), priority, handler);
    }

    public static ThreadPool get(String prefix, int size, ThreadPool.Priority priority) {
        return ThreadPoolFactory.get(prefix, size, priority, new LoggingUncaughtExceptionHandler());
    }

    public static ThreadPool get(String prefix, int size, Thread.UncaughtExceptionHandler handler) {
        return ThreadPoolFactory.get(prefix, size, ThreadPool.Priority.norm, handler);
    }

    public static ThreadPool get(String prefix, int size, ThreadPool.Priority priority, Thread.UncaughtExceptionHandler handler) {
        return ThreadPoolFactory.get(prefix, size, priority, new LinkedBlockingQueue<Runnable>(), handler);
    }

    public static ThreadPool get(String prefix, int size, ThreadPool.Priority priority, BlockingQueue<Runnable> queue, Thread.UncaughtExceptionHandler handler) {
        return new ThreadPoolFactory().create(prefix, size, priority, queue, handler);
    }
}

