/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.random;

import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.random.SecureRandomProvider;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import org.apache.log4j.Logger;

public class DefaultSecureRandomProvider
implements SecureRandomProvider {
    private static final Logger log = Logger.getLogger(DefaultSecureRandomProvider.class);
    private static final Object lock = new Object();
    private static DefaultSecureRandomProvider factory;
    private static SecureRandom seeder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultSecureRandomProvider get() {
        Object object = lock;
        synchronized (object) {
            if (null == factory) {
                factory = new DefaultSecureRandomProvider();
            }
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecureRandom provide() {
        Object object = lock;
        synchronized (object) {
            if (null == seeder) {
                try {
                    seeder = SecureRandom.getInstance(PreferencesFactory.get().getProperty("connection.ssl.securerandom.algorithm"), PreferencesFactory.get().getProperty("connection.ssl.securerandom.provider"));
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                    log.warn((Object)String.format("Failure %s obtaining secure random", e.getMessage()));
                    return null;
                }
            }
            return seeder;
        }
    }
}

