/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.local.DefaultLocalDirectoryFeature;
import ch.cyberduck.core.local.features.Touch;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class DefaultLocalTouchFeature
implements Touch {
    private static final Logger log = Logger.getLogger(DefaultLocalTouchFeature.class);

    @Override
    public void touch(Local file) throws AccessDeniedException {
        try {
            try {
                Files.createFile(Paths.get(file.getAbsolute(), new String[0]), new FileAttribute[0]);
            }
            catch (NoSuchFileException e) {
                Local parent = file.getParent();
                new DefaultLocalDirectoryFeature().mkdir(parent);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Created folder %s", parent));
                }
                Files.createFile(Paths.get(file.getAbsolute(), new String[0]), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                log.warn((Object)String.format("File %s already exists", file));
                if (Files.isDirectory(Paths.get(file.getAbsolute(), new String[0]), new LinkOption[0])) {
                    throw new LocalAccessDeniedException(MessageFormat.format(LocaleFactory.localizedString("Cannot create {0}", "Error"), file.getAbsolute()), e);
                }
                return;
            }
        }
        catch (IOException e) {
            throw new LocalAccessDeniedException(MessageFormat.format(LocaleFactory.localizedString("Cannot create {0}", "Error"), file.getAbsolute()), e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Created file %s", file));
        }
    }
}

