/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.threading.DefaultFailureDiagnostics;
import ch.cyberduck.core.transfer.DisabledTransferErrorCallback;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class TransferErrorCallbackControllerFactory
extends Factory<TransferErrorCallback> {
    private static final Logger log = Logger.getLogger(TransferErrorCallbackControllerFactory.class);

    public TransferErrorCallbackControllerFactory() {
        super("factory.transfererrorcallback.class");
    }

    public TransferErrorCallback create(Controller c) {
        try {
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{c.getClass()});
            if (null == constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", c.getClass()));
                return (TransferErrorCallback)this.clazz.newInstance();
            }
            return (TransferErrorCallback)constructor.newInstance(c);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error((Object)String.format("Failure loading callback class %s. %s", this.clazz, e.getMessage()));
            return new DisabledTransferErrorCallback();
        }
    }

    public static TransferErrorCallback get(Controller c) {
        final TransferErrorCallback proxy = new TransferErrorCallbackControllerFactory().create(c);
        return new TransferErrorCallback(){

            @Override
            public boolean prompt(TransferItem item, TransferStatus status, BackgroundException failure, int pending) throws BackgroundException {
                switch (new DefaultFailureDiagnostics().determine(failure)) {
                    case cancel: {
                        return false;
                    }
                }
                if (pending == 0) {
                    throw failure;
                }
                if (pending == 1) {
                    throw failure;
                }
                return proxy.prompt(item, status, failure, pending);
            }
        };
    }
}

