/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.CountingMetrics;
import ch.cyberduck.core.DefaulPromptUrlProvider;
import ch.cyberduck.core.DisabledMetrics;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.LoggingTranscriptListener;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Metrics;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Download;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultCopyFeature;
import ch.cyberduck.core.shared.DefaultDownloadFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import ch.cyberduck.core.shared.DefaultSearchFeature;
import ch.cyberduck.core.shared.DefaultUploadFeature;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import ch.cyberduck.core.shared.DisabledBulkFeature;
import ch.cyberduck.core.shared.DisabledMoveFeature;
import ch.cyberduck.core.shared.DisabledQuotaFeature;
import ch.cyberduck.core.shared.NullFileidProvider;
import ch.cyberduck.core.threading.CancelCallback;
import ch.cyberduck.core.vault.VaultRegistry;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public abstract class Session<C>
implements TranscriptListener {
    private static final Logger log = Logger.getLogger(Session.class);
    private static final TranscriptListener transcript = new LoggingTranscriptListener();
    protected final Host host;
    private Metrics metrics = new DisabledMetrics();
    protected C client;
    protected VaultRegistry registry = VaultRegistry.DISABLED;
    private final Set<TranscriptListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private State state = State.closed;

    public boolean alert(ConnectionCallback callback) throws BackgroundException {
        if (this.host.getProtocol().isSecure()) {
            return false;
        }
        if (this.host.getCredentials().isAnonymousLogin()) {
            return false;
        }
        Preferences preferences = PreferencesFactory.get();
        if (preferences.getBoolean(String.format("connection.unsecure.%s", this.host.getHostname()))) {
            return false;
        }
        return preferences.getBoolean(String.format("connection.unsecure.warning.%s", new Object[]{this.host.getProtocol().getScheme()}));
    }

    public Session<?> withListener(TranscriptListener listener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Add listener %s", listener));
        }
        this.listeners.add(listener);
        return this;
    }

    public Session<?> removeListener(TranscriptListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public Session<?> withRegistry(VaultRegistry registry) {
        this.registry = registry;
        return this;
    }

    protected Session(Host h) {
        this.host = h;
    }

    public C getClient() {
        return this.client;
    }

    public void enableMetrics() {
        this.metrics = new CountingMetrics();
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public C open(Proxy proxy, HostKeyCallback key, LoginCallback login, CancelCallback cancel) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Connection will open to %s", this.host));
        }
        this.state = State.opening;
        this.client = this.connect(proxy, key, login, cancel);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Connection did open to %s", this.host));
        }
        this.state = State.open;
        return this.client;
    }

    protected abstract C connect(Proxy var1, HostKeyCallback var2, LoginCallback var3, CancelCallback var4) throws BackgroundException;

    public abstract void login(Proxy var1, LoginCallback var2, CancelCallback var3) throws BackgroundException;

    public void close() throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Connection will close to %s", this.host));
        }
        try {
            switch (this.state) {
                case open: {
                    this.state = State.closing;
                    this.logout();
                    this.disconnect();
                }
            }
            this.state = State.closed;
        }
        catch (Throwable throwable) {
            this.state = State.closed;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Connection did close to %s", this.host));
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Connection did close to %s", this.host));
        }
    }

    public void interrupt() throws BackgroundException {
        try {
            switch (this.state) {
                case open: {
                    this.state = State.closing;
                    this.disconnect();
                }
            }
            this.state = State.closed;
        }
        catch (Throwable throwable) {
            this.state = State.closed;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Connection did close to %s", this.host));
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Connection did close to %s", this.host));
        }
    }

    protected abstract void logout() throws BackgroundException;

    protected void disconnect() {
        this.state = State.closed;
        this.listeners.clear();
        this.client = null;
    }

    public Host getHost() {
        return this.host;
    }

    public Protocol.Case getCaseSensitivity() {
        return this.host.getProtocol().getCaseSensitivity();
    }

    public boolean isConnected() {
        return this.state == State.open;
    }

    public State getState() {
        return this.state;
    }

    @Override
    public void log(TranscriptListener.Type request, String message) {
        transcript.log(request, message);
        for (TranscriptListener listener : this.listeners) {
            listener.log(request, message);
        }
    }

    public <T> T getFeature(Class<T> type) {
        this.metrics.increment(type);
        return this.getFeature(type, this._getFeature(type));
    }

    public <T> T getFeature(Class<T> type, T feature) {
        return this.registry.getFeature(this, type, feature);
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == Upload.class) {
            return (T)new DefaultUploadFeature(this.getFeature(Write.class));
        }
        if (type == Download.class) {
            return (T)new DefaultDownloadFeature(this.getFeature(Read.class));
        }
        if (type == Bulk.class) {
            return (T)new DisabledBulkFeature();
        }
        if (type == Move.class) {
            return (T)new DisabledMoveFeature();
        }
        if (type == Copy.class) {
            return (T)new DefaultCopyFeature(this);
        }
        if (type == UrlProvider.class) {
            return (T)new DefaultUrlProvider(this.host);
        }
        if (type == PromptUrlProvider.class) {
            return (T)new DefaulPromptUrlProvider(this.getFeature(UrlProvider.class));
        }
        if (type == Find.class) {
            return (T)new DefaultFindFeature(this);
        }
        if (type == AttributesFinder.class) {
            return (T)new DefaultAttributesFinderFeature(this);
        }
        if (type == Home.class) {
            return (T)new DefaultHomeFinderService(this.host);
        }
        if (type == Search.class) {
            return (T)new DefaultSearchFeature(this);
        }
        if (type == IdProvider.class) {
            return (T)new NullFileidProvider();
        }
        if (type == Quota.class) {
            return (T)new DisabledQuotaFeature();
        }
        return this.host.getProtocol().getFeature(type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Session{");
        sb.append("host=").append(this.host);
        sb.append(", state=").append((Object)this.state);
        sb.append('}');
        return sb.toString();
    }

    public static enum State {
        opening,
        open,
        closing,
        closed;

    }
}

