/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostFilter;
import ch.cyberduck.core.exception.AccessDeniedException;

public class FilterHostCollection
extends AbstractHostCollection {
    private static final long serialVersionUID = -2154002477046004380L;
    private final AbstractHostCollection source;

    public FilterHostCollection(AbstractHostCollection source, HostFilter filter) {
        this.source = source;
        for (Host bookmark : source) {
            if (!filter.accept(bookmark)) continue;
            this.add(bookmark);
        }
        this.addListener(new ProxyHostCollectionListener(source));
    }

    @Override
    public boolean allowsAdd() {
        return this.source.allowsAdd();
    }

    @Override
    public boolean allowsDelete() {
        return this.source.allowsDelete();
    }

    @Override
    public boolean allowsEdit() {
        return this.source.allowsEdit();
    }

    @Override
    public void save() {
        this.source.save();
    }

    @Override
    public void load() throws AccessDeniedException {
        this.source.load();
    }

    private static final class ProxyHostCollectionListener
    implements CollectionListener<Host> {
        private final AbstractHostCollection source;

        public ProxyHostCollectionListener(AbstractHostCollection source) {
            this.source = source;
        }

        @Override
        public void collectionLoaded() {
            this.source.collectionLoaded();
        }

        @Override
        public void collectionItemAdded(Host item) {
            this.source.add(item);
        }

        @Override
        public void collectionItemRemoved(Host item) {
            this.source.remove(item);
        }

        @Override
        public void collectionItemChanged(Host item) {
            this.source.collectionItemChanged(item);
        }
    }
}

