/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Host;
import org.apache.commons.lang3.StringUtils;

public final class BookmarkNameProvider {
    private BookmarkNameProvider() {
    }

    public static String toString(Host bookmark) {
        return BookmarkNameProvider.toString(bookmark, false);
    }

    public static String toString(Host bookmark, boolean username) {
        if (StringUtils.isEmpty((CharSequence)bookmark.getNickname())) {
            if (StringUtils.isNotBlank((CharSequence)bookmark.getProtocol().getDefaultNickname())) {
                return bookmark.getProtocol().getDefaultNickname();
            }
            String hostname = BookmarkNameProvider.toHostname(bookmark, username);
            if (StringUtils.isBlank((CharSequence)hostname)) {
                return bookmark.getProtocol().getName();
            }
            return hostname + " " + '\u2013' + " " + bookmark.getProtocol().getName();
        }
        return bookmark.getNickname();
    }

    public static String toHostname(Host bookmark) {
        return BookmarkNameProvider.toHostname(bookmark, false);
    }

    public static String toHostname(Host bookmark, boolean username) {
        StringBuilder prefix = new StringBuilder();
        if (username && !bookmark.getCredentials().isAnonymousLogin() && StringUtils.isNotBlank((CharSequence)bookmark.getCredentials().getUsername())) {
            prefix.append(String.format("%s@", bookmark.getCredentials().getUsername()));
        }
        if (StringUtils.isNotBlank((CharSequence)bookmark.getHostname())) {
            prefix.append(StringUtils.strip((String)bookmark.getHostname()));
        } else if (StringUtils.isNotBlank((CharSequence)bookmark.getProtocol().getDefaultHostname())) {
            prefix.append(StringUtils.strip((String)bookmark.getProtocol().getDefaultHostname()));
        }
        return prefix.toString();
    }
}

