/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.TransferAcceleration;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.model.AccelerateConfig;
import org.jets3t.service.utils.ServiceUtils;

public class S3TransferAccelerationService
implements TransferAcceleration {
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3Session session;
    public static final String S3_ACCELERATE_HOSTNAME = "s3-accelerate.amazonaws.com";
    public static final String S3_ACCELERATE_DUALSTACK_HOSTNAME = "s3-accelerate.dualstack.amazonaws.com";
    private final String hostname;

    public S3TransferAccelerationService(S3Session session) {
        this(session, S3_ACCELERATE_DUALSTACK_HOSTNAME);
    }

    public S3TransferAccelerationService(S3Session session, String hostname) {
        this.session = session;
        this.hostname = hostname;
    }

    public boolean getStatus(Path file) throws BackgroundException {
        Path bucket = this.containerService.getContainer(file);
        try {
            return ((RequestEntityRestStorageService)((Object)this.session.getClient())).getAccelerateConfig(bucket.getName()).isEnabled();
        }
        catch (S3ServiceException failure) {
            throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", failure, bucket);
        }
    }

    public void setStatus(Path file, boolean enabled) throws BackgroundException {
        Path bucket = this.containerService.getContainer(file);
        try {
            if (!ServiceUtils.isBucketNameValidDNSName((String)bucket.getName())) {
                throw new InteroperabilityException("The name of the bucket used for Transfer Acceleration must be DNS-compliant and must not contain periods.");
            }
            ((RequestEntityRestStorageService)((Object)this.session.getClient())).setAccelerateConfig(bucket.getName(), new AccelerateConfig(enabled));
        }
        catch (S3ServiceException failure) {
            throw new S3ExceptionMappingService().map("Failure to write attributes of {0}", failure, bucket);
        }
    }

    public boolean prompt(Host bookmark, Path file, ConnectionCallback prompt) throws BackgroundException {
        try {
            prompt.warn(bookmark, LocaleFactory.localizedString((String)"Enable Amazon S3 Transfer Acceleration", (String)"S3"), LocaleFactory.localizedString((String)"Amazon S3 Transfer Acceleration makes data transfers into and out of Amazon S3 buckets faster, and only charges if there is a performance improvement.", (String)"S3"), LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), LocaleFactory.localizedString((String)"Change", (String)"Credentials"), String.format("s3.acceleration.%s", bookmark.getHostname()));
            return false;
        }
        catch (ConnectionCanceledException e) {
            this.setStatus(file, true);
            return true;
        }
    }

    public void configure(boolean enable, Path file) {
        Jets3tProperties options = ((RequestEntityRestStorageService)((Object)this.session.getClient())).getConfiguration();
        if (enable) {
            options.setProperty("s3service.s3-endpoint", this.hostname);
            options.setProperty("s3service.disable-dns-buckets", String.valueOf(false));
            options.setProperty("s3service.disable-expect-continue", String.valueOf(true));
        } else {
            options.loadAndReplaceProperties(((RequestEntityRestStorageService)((Object)this.session.getClient())).getConfiguration(), this.toString());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("S3TransferAccelerationService{");
        sb.append("hostname='").append(this.hostname).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

