/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.http.ExtendedHttpRequestRetryHandler;
import java.io.IOException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.JetS3tRequestAuthorizer;

public class S3HttpRequestRetryHandler
extends ExtendedHttpRequestRetryHandler {
    private static final Logger log = Logger.getLogger(S3HttpRequestRetryHandler.class);
    private final JetS3tRequestAuthorizer authorizer;

    public S3HttpRequestRetryHandler(JetS3tRequestAuthorizer authorizer, int retryCount) {
        super(retryCount);
        this.authorizer = authorizer;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        Object attribute;
        if (super.retryRequest(exception, executionCount, context) && (attribute = context.getAttribute("http.request")) instanceof HttpUriRequest) {
            HttpUriRequest method = (HttpUriRequest)attribute;
            log.warn((Object)String.format("Retrying request %s", method));
            try {
                this.authorizer.authorizeHttpRequest(method, context, null);
                return true;
            }
            catch (ServiceException e) {
                log.warn((Object)"Unable to generate updated authorization string for retried request", (Throwable)e);
            }
        }
        return false;
    }
}

