/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3HttpRequestRetryHandler;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3Protocol;
import ch.cyberduck.core.s3.S3Session;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.XmlResponsesSaxParser;
import org.jets3t.service.impl.rest.httpclient.JetS3tRequestAuthorizer;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;
import org.jets3t.service.model.StorageBucketLoggingStatus;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.model.WebsiteConfig;

public class RequestEntityRestStorageService
extends RestS3Service {
    private static final Logger log = Logger.getLogger(RequestEntityRestStorageService.class);
    private final S3Session session;
    private final Jets3tProperties properties;
    private final Preferences preferences = PreferencesFactory.get();

    private static Jets3tProperties toProperties(Host bookmark, S3Protocol.AuthenticationHeaderSignatureVersion signatureVersion) {
        Jets3tProperties properties = new Jets3tProperties();
        Preferences preferences = PreferencesFactory.get();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Configure for endpoint %s", bookmark));
        }
        if (bookmark.getHostname().endsWith(preferences.getProperty("s3.hostname.default"))) {
            properties.setProperty("s3service.s3-endpoint", preferences.getProperty("s3.hostname.default"));
            properties.setProperty("s3service.disable-dns-buckets", String.valueOf(preferences.getBoolean("s3.bucket.virtualhost.disable")));
        } else {
            properties.setProperty("s3service.s3-endpoint", bookmark.getHostname());
            if (InetAddressUtils.isIPv4Address((String)bookmark.getHostname()) || InetAddressUtils.isIPv6Address((String)bookmark.getHostname())) {
                properties.setProperty("s3service.disable-dns-buckets", String.valueOf(true));
            } else {
                properties.setProperty("s3service.disable-dns-buckets", String.valueOf(preferences.getBoolean("s3.bucket.virtualhost.disable")));
            }
        }
        properties.setProperty("s3service.enable-storage-classes", String.valueOf(true));
        if (StringUtils.isNotBlank((CharSequence)bookmark.getProtocol().getContext()) && !Scheme.isURL((String)bookmark.getProtocol().getContext())) {
            properties.setProperty("s3service.s3-endpoint-virtual-path", PathNormalizer.normalize((String)bookmark.getProtocol().getContext()));
        }
        properties.setProperty("s3service.https-only", String.valueOf(bookmark.getProtocol().isSecure()));
        if (bookmark.getProtocol().isSecure()) {
            properties.setProperty("s3service.s3-endpoint-https-port", String.valueOf(bookmark.getPort()));
        } else {
            properties.setProperty("s3service.s3-endpoint-http-port", String.valueOf(bookmark.getPort()));
        }
        properties.setProperty("s3service.internal-error-retry-max", String.valueOf(0));
        properties.setProperty("s3service.max-thread-count", String.valueOf(1));
        properties.setProperty("httpclient.proxy-autodetect", String.valueOf(false));
        properties.setProperty("httpclient.retry-max", String.valueOf(0));
        properties.setProperty("storage-service.internal-error-retry-max", String.valueOf(0));
        properties.setProperty("storage-service.request-signature-version", signatureVersion.toString());
        properties.setProperty("storage-service.disable-live-md5", String.valueOf(true));
        properties.setProperty("storage-service.default-region", bookmark.getRegion());
        properties.setProperty("xmlparser.sanitize-listings", String.valueOf(false));
        for (Map.Entry property : bookmark.getProtocol().getProperties().entrySet()) {
            properties.setProperty((String)property.getKey(), (String)property.getValue());
        }
        return properties;
    }

    public RequestEntityRestStorageService(final S3Session session, HttpClientBuilder configuration) {
        super(null, new PreferencesUseragentProvider().get(), null, RequestEntityRestStorageService.toProperties(session.getHost(), session.getSignatureVersion()));
        this.session = session;
        this.properties = this.getJetS3tProperties();
        configuration.disableContentCompression();
        configuration.setRetryHandler((HttpRequestRetryHandler)new S3HttpRequestRetryHandler((JetS3tRequestAuthorizer)this, this.preferences.getInteger("http.connections.retry")));
        configuration.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

            public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                if (response.containsHeader("x-amz-bucket-region")) {
                    String host = ((HttpUriRequest)request).getURI().getHost();
                    if (!StringUtils.equals((CharSequence)session.getHost().getHostname(), (CharSequence)host)) {
                        RequestEntityRestStorageService.this.regionEndpointCache.putRegionForBucketName(StringUtils.split((String)StringUtils.removeEnd((String)((HttpUriRequest)request).getURI().getHost(), (String)session.getHost().getHostname()), (String)".")[0], response.getFirstHeader("x-amz-bucket-region").getValue());
                    }
                }
                return super.getRedirect(request, response, context);
            }
        });
        this.setHttpClient(configuration.build());
    }

    public Jets3tProperties getConfiguration() {
        return this.properties;
    }

    protected void initializeDefaults() {
    }

    protected HttpClientBuilder initHttpClientBuilder() {
        return null;
    }

    protected void initializeProxy(HttpClientBuilder httpClientBuilder) {
    }

    protected HttpUriRequest setupConnection(RestStorageService.HTTP_METHOD method, String bucketName, String objectKey, Map<String, String> requestParameters) throws S3ServiceException {
        Host host = this.session.getHost();
        if (S3Session.isAwsHostname(host.getHostname(), false)) {
            if (this.properties.getStringProperty("s3service.s3-endpoint", this.preferences.getProperty("s3.hostname.default")).matches("s3-accelerate(\\.dualstack)?\\.amazonaws\\.com")) {
                log.debug((Object)"Skip adjusting endpoint with transfer acceleration");
            } else if (requestParameters == null || !requestParameters.containsKey("location")) {
                try {
                    Location.Name region = new S3LocationFeature(this.session, this.regionEndpointCache).getLocation(bucketName);
                    if (Location.unknown == region) {
                        log.warn((Object)String.format("Failure determining bucket location for %s", bucketName));
                    } else {
                        String endpoint = this.preferences.getBoolean("s3.endpoint.dualstack.enable") ? String.format(this.preferences.getProperty("s3.endpoint.format.ipv6"), region.getIdentifier()) : String.format(this.preferences.getProperty("s3.endpoint.format.ipv4"), region.getIdentifier());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Set endpoint to %s", endpoint));
                        }
                        this.properties.setProperty("s3service.s3-endpoint", endpoint);
                    }
                }
                catch (BackgroundException e) {
                    log.error((Object)String.format("Failure %s determining bucket location for %s", new Object[]{e, bucketName}));
                }
            }
        }
        HttpUriRequest request = super.setupConnection(method, bucketName, objectKey, requestParameters);
        if (this.preferences.getBoolean("s3.upload.expect-continue") && "PUT".equals(request.getMethod()) && !this.properties.getBoolProperty("s3service.disable-expect-continue", false)) {
            request.addHeader("Expect", "100-continue");
        }
        if (this.preferences.getBoolean("s3.bucket.requesterpays") && S3Session.isAwsHostname(host.getHostname()) && ("GET".equals(request.getMethod()) || "POST".equals(request.getMethod())) && !this.properties.getBoolProperty("s3service.disable-request-payer", false)) {
            request.addHeader("x-amz-request-payer", "requester");
        }
        return request;
    }

    protected boolean isTargettingGoogleStorageService() {
        return this.session.getHost().getHostname().equals(Constants.GS_DEFAULT_HOSTNAME);
    }

    public void putObjectWithRequestEntityImpl(String bucketName, StorageObject object, HttpEntity requestEntity, Map<String, String> requestParams) throws ServiceException {
        super.putObjectWithRequestEntityImpl(bucketName, object, requestEntity, requestParams);
    }

    public StorageObject getObjectImpl(boolean headOnly, String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd, String versionId, Map<String, Object> requestHeaders, Map<String, String> requestParameters) throws ServiceException {
        return super.getObjectImpl(headOnly, bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd, versionId, requestHeaders, requestParameters);
    }

    public void verifyExpectedAndActualETagValues(String expectedETag, StorageObject uploadedObject) throws ServiceException {
        if (StringUtils.isBlank((CharSequence)uploadedObject.getETag())) {
            log.warn((Object)"No ETag to verify");
            return;
        }
        super.verifyExpectedAndActualETagValues(expectedETag, uploadedObject);
    }

    protected String getSignatureIdentifier() {
        return this.session.getSignatureIdentifier();
    }

    public String getRestHeaderPrefix() {
        return this.session.getRestHeaderPrefix();
    }

    public String getRestMetadataPrefix() {
        return this.session.getRestMetadataPrefix();
    }

    protected XmlResponsesSaxParser getXmlResponseSaxParser() throws ServiceException {
        return this.session.getXmlResponseSaxParser();
    }

    public void setBucketLoggingStatusImpl(String bucketName, StorageBucketLoggingStatus status) throws ServiceException {
        super.setBucketLoggingStatusImpl(bucketName, status);
    }

    public StorageBucketLoggingStatus getBucketLoggingStatusImpl(String bucketName) throws ServiceException {
        return super.getBucketLoggingStatusImpl(bucketName);
    }

    public WebsiteConfig getWebsiteConfigImpl(String bucketName) throws ServiceException {
        return super.getWebsiteConfigImpl(bucketName);
    }

    public void setWebsiteConfigImpl(String bucketName, WebsiteConfig config) throws ServiceException {
        super.setWebsiteConfigImpl(bucketName, config);
    }

    public void deleteWebsiteConfigImpl(String bucketName) throws ServiceException {
        super.deleteWebsiteConfigImpl(bucketName);
    }

    public void authorizeHttpRequest(HttpUriRequest httpMethod, HttpContext context, String forceRequestSignatureVersion) throws ServiceException {
        if (forceRequestSignatureVersion != null) {
            S3Protocol.AuthenticationHeaderSignatureVersion authenticationHeaderSignatureVersion = S3Protocol.AuthenticationHeaderSignatureVersion.valueOf(StringUtils.remove((String)forceRequestSignatureVersion, (String)"-"));
            log.warn((Object)String.format("Switched authentication signature version to %s", forceRequestSignatureVersion));
            this.session.setSignatureVersion(authenticationHeaderSignatureVersion);
        }
        super.authorizeHttpRequest(httpMethod, context, forceRequestSignatureVersion);
    }

    public HttpResponse performRestGet(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, Object> requestHeaders, int[] expectedStatusCodes) throws ServiceException {
        return super.performRestGet(bucketName, objectKey, requestParameters, requestHeaders, expectedStatusCodes);
    }

    protected boolean isXmlContentType(String contentType) {
        if (null == contentType) {
            return false;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"application/xml")) {
            return true;
        }
        return StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"text/xml");
    }
}

