/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.collections4.map.UnmodifiableMap;

public class LookupMap<K extends String, V>
implements Map<K, V> {
    private final Map<K, V> wrapped;
    private final CaseInsensitiveMap<K, V> lowercaseWrapped;
    private static final String JAVA_UNMODIFIABLE_MAP = "java.util.Collections$UnmodifiableMap";
    private static final String APACHE_UNMODIFIABLE_MAP = "org.apache.commons.collections4.map.UnmodifiableMap";
    private static final String IMMUTABLE_MAP = "com.google.common.collect.ImmutableMap";

    public LookupMap(Map<K, V> backingMap) {
        this.wrapped = this.isUnmodifiable(backingMap) ? backingMap : Collections.unmodifiableMap(backingMap);
        this.lowercaseWrapped = new CaseInsensitiveMap(this.wrapped);
    }

    private boolean isUnmodifiable(Map<K, V> map) {
        return map.getClass().getName().equals(JAVA_UNMODIFIABLE_MAP) || map.getClass().getName().equals(APACHE_UNMODIFIABLE_MAP) || map.getClass().getName().equals(IMMUTABLE_MAP) || map instanceof UnmodifiableMap;
    }

    public Set<K> lowercaseKeySet() {
        return this.lowercaseWrapped.keySet();
    }

    public boolean containsKeyCaseInsensitive(K key) {
        return this.lowercaseWrapped.containsKey(key);
    }

    public V getWithCaseInsensitiveKey(K key) {
        return (V)this.lowercaseWrapped.get(key);
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.wrapped.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.wrapped.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.wrapped.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.wrapped.putAll(m);
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.wrapped.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.wrapped.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.wrapped.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        return Objects.equals(this.wrapped, that);
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.wrapped.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.wrapped.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.wrapped.replaceAll(function);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.wrapped.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.wrapped.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.wrapped.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.wrapped.replace(key, value);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.wrapped.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.wrapped.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.wrapped.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.wrapped.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }
}

