/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.util;

import com.joyent.manta.exception.MantaReflectionException;
import com.joyent.manta.util.Cloner;
import com.joyent.manta.util.DigestCloner;
import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.util.Memoable;

public final class HmacCloner
implements Cloner<HMac> {
    private static final Field FIELD_IPAD_STATE = FieldUtils.getField(HMac.class, (String)"ipadState", (boolean)true);
    private static final Field FIELD_OPAD_STATE = FieldUtils.getField(HMac.class, (String)"opadState", (boolean)true);

    @Override
    public HMac createClone(HMac source) {
        Digest originalDigest = source.getUnderlyingDigest();
        Digest clonedDigest = new DigestCloner().createClone(originalDigest);
        HMac cloned = new HMac(clonedDigest);
        try {
            Memoable ipadState = (Memoable)FieldUtils.readField((Field)FIELD_IPAD_STATE, (Object)source, (boolean)true);
            Memoable opadState = (Memoable)FieldUtils.readField((Field)FIELD_OPAD_STATE, (Object)source, (boolean)true);
            FieldUtils.writeField((Field)FIELD_IPAD_STATE, (Object)cloned, (Object)ipadState.copy());
            FieldUtils.writeField((Field)FIELD_OPAD_STATE, (Object)cloned, (Object)opadState.copy());
        }
        catch (IllegalAccessException e) {
            throw new MantaReflectionException(e);
        }
        return cloned;
    }
}

