/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http.entity;

import com.joyent.manta.http.entity.MemoryBackedEntity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.Validate;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;

public class ExposedByteArrayEntity
extends AbstractHttpEntity
implements MemoryBackedEntity,
Cloneable {
    private final byte[] buffer;
    private final int offset;
    private final int length;

    public ExposedByteArrayEntity(byte[] buffer, ContentType contentType) {
        this(buffer, 0, buffer.length, contentType);
    }

    public ExposedByteArrayEntity(byte[] buffer, int offset, int length, ContentType contentType) {
        Validate.notNull((Object)buffer, (String)"Byte array must not be null", (Object[])new Object[0]);
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.length;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.buffer, this.offset, this.length);
    }

    public void writeTo(OutputStream out) throws IOException {
        Validate.notNull((Object)out, (String)"OutputStream should not be null", (Object[])new Object[0]);
        out.write(this.buffer, this.offset, this.length);
        out.flush();
    }

    public boolean isStreaming() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public ByteBuffer getBackingBuffer() {
        return ByteBuffer.wrap(this.buffer, this.offset, this.length);
    }
}

