/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.exception;

import com.joyent.manta.domain.ObjectType;
import com.joyent.manta.exception.MantaClientException;
import com.joyent.manta.http.MantaHttpHeaders;
import org.apache.commons.lang3.Validate;

public class MantaUnexpectedObjectTypeException
extends MantaClientException {
    private static final long serialVersionUID = -1028368819651385028L;
    private final ObjectType expected;
    private final ObjectType actual;
    private MantaHttpHeaders responseHeaders;

    public MantaUnexpectedObjectTypeException(ObjectType expected, ObjectType actual) {
        super(MantaUnexpectedObjectTypeException.msg(expected, actual));
        this.expected = expected;
        this.actual = actual;
        this.updateContext();
    }

    public MantaUnexpectedObjectTypeException(String message, ObjectType expected, ObjectType actual) {
        super(message);
        this.expected = expected;
        this.actual = actual;
        this.updateContext();
    }

    public MantaUnexpectedObjectTypeException(Throwable cause, ObjectType expected, ObjectType actual) {
        super(MantaUnexpectedObjectTypeException.msg(expected, actual), cause);
        this.expected = expected;
        this.actual = actual;
        this.updateContext();
    }

    public MantaUnexpectedObjectTypeException(String message, Throwable cause, ObjectType expected, ObjectType actual) {
        super(message, cause);
        this.expected = expected;
        this.actual = actual;
        this.updateContext();
    }

    public ObjectType getExpected() {
        return this.expected;
    }

    public ObjectType getActual() {
        return this.actual;
    }

    public MantaHttpHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(MantaHttpHeaders responseHeaders) {
        this.responseHeaders = responseHeaders;
        this.setContextValue("responseHeaders", responseHeaders.toString());
    }

    private void updateContext() {
        Validate.notNull((Object)((Object)this.expected), (String)"Expected value should not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)this.actual), (String)"Actual value should not be null", (Object[])new Object[0]);
        Validate.isTrue((!this.expected.equals((Object)this.actual) ? 1 : 0) != 0, (String)"Expected and actual shouldn't be equal. If they were equal - we wouldn't have an exception.", (Object[])new Object[0]);
        this.setContextValue("expectedObjectType", (Object)this.expected);
        this.setContextValue("actualObjectType", (Object)this.actual);
    }

    private static String msg(ObjectType expected, ObjectType actual) {
        String format = "Expected the object type [%s] actually [%s]";
        return String.format("Expected the object type [%s] actually [%s]", new Object[]{expected, actual});
    }
}

