/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.config;

import com.codahale.metrics.MetricRegistry;
import com.joyent.manta.config.MetricReporterMode;
import java.util.UUID;
import org.apache.commons.lang3.Validate;

public final class MantaClientMetricConfiguration {
    private final UUID clientId;
    private final MetricRegistry registry;
    private final MetricReporterMode reporterMode;
    private final Integer periodicReporterOutputInterval;

    public MantaClientMetricConfiguration(UUID clientId, MetricRegistry registry) {
        this.clientId = (UUID)Validate.notNull((Object)clientId);
        this.registry = (MetricRegistry)Validate.notNull((Object)registry);
        this.reporterMode = null;
        this.periodicReporterOutputInterval = null;
    }

    public MantaClientMetricConfiguration(UUID clientId, MetricRegistry registry, MetricReporterMode reporterMode, Integer periodicReporterOutputInterval) {
        this.clientId = (UUID)Validate.notNull((Object)clientId);
        this.registry = (MetricRegistry)Validate.notNull((Object)registry);
        this.reporterMode = (MetricReporterMode)((Object)Validate.notNull((Object)((Object)reporterMode)));
        this.periodicReporterOutputInterval = this.validateReporterOutputInterval(periodicReporterOutputInterval);
    }

    public UUID getClientId() {
        return this.clientId;
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public MetricReporterMode getReporterMode() {
        return this.reporterMode;
    }

    public Integer getPeriodicReporterOutputInterval() {
        return this.periodicReporterOutputInterval;
    }

    private Integer validateReporterOutputInterval(Integer reporterOutputInterval) {
        if (!this.reporterMode.equals((Object)MetricReporterMode.SLF4J)) {
            return reporterOutputInterval;
        }
        Validate.notNull((Object)reporterOutputInterval, (String)"Reporter output interval must be set when SLF4J reporter is selected", (Object[])new Object[0]);
        Validate.inclusiveBetween((Object)1, (Object)Integer.MAX_VALUE, (Comparable)reporterOutputInterval, (String)"Reporter output interval must be greater than 0 when SLF4J reporter is selected", (Object[])new Object[0]);
        return reporterOutputInterval;
    }
}

