/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.config;

import com.joyent.http.signature.KeyFingerprinter;
import com.joyent.http.signature.KeyPairLoader;
import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.exception.ConfigurationException;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;

public class KeyPairFactory {
    private final ConfigContext config;

    public KeyPairFactory(ConfigContext config) {
        this.config = config;
    }

    public KeyPair createKeyPair() {
        KeyPair keyPair;
        String privateKeyContent = this.config.getPrivateKeyContent();
        String keyPath = this.config.getMantaKeyPath();
        String password = this.config.getPassword();
        char[] charPassword = password != null ? password.toCharArray() : null;
        if (privateKeyContent != null) {
            try {
                keyPair = KeyPairLoader.getKeyPair((String)privateKeyContent, (char[])charPassword);
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to read supplied private key content", e);
            }
        } else if (keyPath != null) {
            try {
                keyPair = KeyPairLoader.getKeyPair((File)new File(keyPath), (char[])charPassword);
            }
            catch (IOException e) {
                String msg = String.format("Unable to read private key files from path: %s", keyPath);
                throw new ConfigurationException(msg, e);
            }
        } else {
            String msg = "Private key content setting must be set if key file path is not set";
            ConfigurationException exception = new ConfigurationException("Private key content setting must be set if key file path is not set");
            exception.setContextValue("config", this.config);
            throw exception;
        }
        if (!KeyFingerprinter.verifyFingerprint((KeyPair)keyPair, (String)this.config.getMantaKeyId())) {
            String msg = String.format("Given fingerprint %s does not match expected key MD5:%s SHA256:%s", this.config.getMantaKeyId(), KeyFingerprinter.md5Fingerprint((KeyPair)keyPair), KeyFingerprinter.sha256Fingerprint((KeyPair)keyPair));
            throw new ConfigurationException(msg);
        }
        return keyPair;
    }
}

