/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import com.joyent.manta.exception.MantaClientEncryptionException;
import com.joyent.manta.util.LookupMap;
import com.joyent.manta.util.MantaUtils;
import com.twmacinta.util.FastMD5Digest;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;

public final class SupportedHmacsLookupMap
extends LookupMap<String, Supplier<HMac>> {
    public static final SupportedHmacsLookupMap INSTANCE = new SupportedHmacsLookupMap();

    private SupportedHmacsLookupMap() {
        super(MantaUtils.unmodifiableMap("HmacMD5", SupportedHmacsLookupMap.hmacSupplierByName("HmacMD5"), "HmacSHA1", SupportedHmacsLookupMap.hmacSupplierByName("HmacSHA1"), "HmacSHA256", SupportedHmacsLookupMap.hmacSupplierByName("HmacSHA256"), "HmacSHA384", SupportedHmacsLookupMap.hmacSupplierByName("HmacSHA384"), "HmacSHA512", SupportedHmacsLookupMap.hmacSupplierByName("HmacSHA512")));
    }

    private static Supplier<HMac> hmacSupplierByName(String algorithm) {
        return () -> {
            if (algorithm.equalsIgnoreCase("HmacMD5")) {
                return new HMac((Digest)new FastMD5Digest());
            }
            if (algorithm.equalsIgnoreCase("HmacSHA1")) {
                return new HMac((Digest)new SHA1Digest());
            }
            if (algorithm.equalsIgnoreCase("HmacSHA256")) {
                return new HMac((Digest)new SHA256Digest());
            }
            if (algorithm.equalsIgnoreCase("HmacSHA384")) {
                return new HMac((Digest)new SHA384Digest());
            }
            if (algorithm.equalsIgnoreCase("HmacSHA512")) {
                return new HMac((Digest)new SHA512Digest());
            }
            String msg = String.format("Hmac algorithm [%s] not supported", algorithm);
            throw new MantaClientEncryptionException(msg);
        };
    }

    public static String hmacNameFromInstance(HMac hmac) {
        Validate.notNull((Object)hmac, (String)"HMAC instance must not be null", (Object[])new Object[0]);
        String digestName = hmac.getUnderlyingDigest().getAlgorithmName();
        return "Hmac" + StringUtils.strip((String)digestName, (String)"-");
    }
}

