/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.joyent.manta.config.ConfigContext;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.lang3.Validate;

final class FindForkJoinPoolFactory {
    private static final String SYSTEM_FORK_JOIN_POOL_PARALLELISM_KEY = "java.util.concurrent.ForkJoinPool.common.parallelism";
    private static final double PERCENT_OF_RESERVED_CONNECTIONS = 0.5;
    private static final int MINIMUM_CONNECTIONS_VIABLE = 1;

    private FindForkJoinPoolFactory() {
    }

    static ForkJoinPool getInstance(ConfigContext config) {
        Validate.notNull((Object)config, (String)"Configuration context is null", (Object[])new Object[0]);
        int maximumConnections = (Integer)Validate.notNull((Object)config.getMaximumConnections(), (String)"Maximum connections setting is null", (Object[])new Object[0]);
        Validate.isTrue((maximumConnections > 0 ? 1 : 0) != 0, (String)"Maximum connections is not greater than zero", (Object[])new Object[0]);
        int parallelism = FindForkJoinPoolFactory.calculateParallelism(maximumConnections);
        return new ForkJoinPool(parallelism);
    }

    private static int calculateParallelism(int maximumConnections) {
        int reserved = FindForkJoinPoolFactory.calculateNumberOfReservedConnections(maximumConnections);
        int maximumUsableConnections = Math.max(maximumConnections - reserved, 1);
        if (maximumUsableConnections == 1) {
            return 1;
        }
        int systemParallelism = FindForkJoinPoolFactory.calculateSystemParallelism();
        return Math.min(maximumUsableConnections, systemParallelism);
    }

    private static int calculateNumberOfReservedConnections(int maximumConnections) {
        double reserved = (double)maximumConnections * 0.5;
        return Math.toIntExact(Math.round(reserved));
    }

    private static int calculateSystemParallelism() {
        Optional<Integer> systemParallelism = FindForkJoinPoolFactory.readSystemForkJoinPoolParallelismSetting();
        return systemParallelism.orElse(Runtime.getRuntime().availableProcessors());
    }

    private static Optional<Integer> readSystemForkJoinPoolParallelismSetting() {
        String parallelismSysProp = System.getProperty(SYSTEM_FORK_JOIN_POOL_PARALLELISM_KEY);
        if (parallelismSysProp == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.valueOf(parallelismSysProp));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }
}

