/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionTimeoutException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.ssl.SSLExceptionMappingService;
import com.microsoft.azure.storage.StorageException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AzureExceptionMappingService
extends AbstractExceptionMappingService<StorageException> {
    public BackgroundException map(StorageException failure) {
        StringBuilder buffer = new StringBuilder();
        this.append(buffer, failure.getMessage());
        if (ExceptionUtils.getRootCause((Throwable)failure) instanceof UnknownHostException) {
            return new NotfoundException(buffer.toString(), (Throwable)failure);
        }
        switch (failure.getHttpStatusCode()) {
            case 403: {
                return new LoginFailureException(buffer.toString(), (Throwable)failure);
            }
            case 404: {
                return new NotfoundException(buffer.toString(), (Throwable)failure);
            }
            case 304: 
            case 400: 
            case 405: 
            case 411: 
            case 412: {
                return new InteroperabilityException(buffer.toString(), (Throwable)failure);
            }
            case 500: {
                return new ConnectionTimeoutException(buffer.toString(), (Throwable)failure);
            }
            case 503: {
                return new RetriableAccessDeniedException(buffer.toString(), (Throwable)failure);
            }
        }
        for (Throwable cause : ExceptionUtils.getThrowableList((Throwable)failure)) {
            if (!(cause instanceof SSLException)) continue;
            return new SSLExceptionMappingService().map(buffer.toString(), (Throwable)((SSLException)cause));
        }
        return this.wrap(failure, buffer);
    }
}

