/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.azure.AzureExceptionMappingService;
import ch.cyberduck.core.azure.AzurePathContainerService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.transfer.TransferStatus;
import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.DeleteSnapshotsOption;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;

public class AzureDeleteFeature
implements Delete {
    private final AzureSession session;
    private final OperationContext context;
    private final PathContainerService containerService = new AzurePathContainerService();

    public AzureDeleteFeature(AzureSession session, OperationContext context) {
        this.session = session;
        this.context = context;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        BlobRequestOptions options;
        ArrayList<Path> containers = new ArrayList<Path>();
        for (Path file : files.keySet()) {
            if (this.containerService.isContainer(file)) {
                containers.add(file);
                continue;
            }
            callback.delete(file);
            try {
                options = new BlobRequestOptions();
                ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getBlockBlobReference(this.containerService.getKey(file)).delete(DeleteSnapshotsOption.INCLUDE_SNAPSHOTS, AccessCondition.generateEmptyCondition(), options, this.context);
            }
            catch (StorageException e) {
                throw new AzureExceptionMappingService().map("Cannot delete {0}", e, file);
            }
            catch (URISyntaxException e) {
                throw new NotfoundException(e.getMessage(), (Throwable)e);
            }
        }
        for (Path file : containers) {
            callback.delete(file);
            try {
                options = new BlobRequestOptions();
                ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).delete(AccessCondition.generateEmptyCondition(), options, this.context);
            }
            catch (StorageException e) {
                throw new AzureExceptionMappingService().map("Cannot delete {0}", e, file);
            }
            catch (URISyntaxException e) {
                throw new NotfoundException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

