/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import com.joyent.manta.client.crypto.AbstractAesCipherDetails;
import com.joyent.manta.client.crypto.AesCipherDetailsFactory;
import com.joyent.manta.client.crypto.ByteRangeConversion;
import com.joyent.manta.client.crypto.SupportedCipherDetails;
import java.nio.ByteBuffer;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.lang3.Validate;

public final class AesCtrCipherDetails
extends AbstractAesCipherDetails {
    public static final SupportedCipherDetails INSTANCE_128_BIT = AesCipherDetailsFactory.buildWith(AesCipherDetailsFactory.CipherMode.CTR, 128);
    public static final SupportedCipherDetails INSTANCE_192_BIT = AesCipherDetailsFactory.buildWith(AesCipherDetailsFactory.CipherMode.CTR, 192);
    public static final SupportedCipherDetails INSTANCE_256_BIT = AesCipherDetailsFactory.buildWith(AesCipherDetailsFactory.CipherMode.CTR, 256);

    protected AesCtrCipherDetails(int keyLengthBits) {
        super(keyLengthBits, "AES/CTR/NoPadding", "HmacMD5");
    }

    @Override
    public long ciphertextSize(long plaintextSize) {
        Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)plaintextSize);
        return plaintextSize + (long)this.getAuthenticationTagOrHmacLengthInBytes();
    }

    @Override
    public long plaintextSize(long ciphertextSize) {
        Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)ciphertextSize);
        return ciphertextSize - (long)this.getAuthenticationTagOrHmacLengthInBytes();
    }

    @Override
    public boolean plaintextSizeCalculationIsAnEstimate() {
        return false;
    }

    @Override
    public ByteRangeConversion translateByteRange(long startInclusive, long endInclusive) {
        long plaintextMax = this.getMaximumPlaintextSizeInBytes();
        if (startInclusive > endInclusive) {
            String msg = "Start position must be precede end position (startInclusive=" + startInclusive + ", endInclusive=" + endInclusive + ")";
            throw new IllegalArgumentException(msg);
        }
        if (startInclusive < 0L) {
            String msg = "Start position must be zero or higher (startInclusive=" + startInclusive + ")";
            throw new IllegalArgumentException(msg);
        }
        if (startInclusive >= plaintextMax) {
            String msg = "Start position must be less than maximum plaintext size (startInclusive=" + startInclusive + ", plaintextMax=" + plaintextMax + ")";
            throw new IllegalArgumentException(msg);
        }
        if (endInclusive < 0L) {
            String msg = "End position must be zero or higher (endInclusive=" + endInclusive + ")";
            throw new IllegalArgumentException(msg);
        }
        if (endInclusive >= plaintextMax) {
            String msg = "End position must be less than maximum plaintext size (endInclusive=" + endInclusive + ", plaintextMax=" + plaintextMax + ")";
            throw new IllegalArgumentException(msg);
        }
        int blockSize = this.getBlockSizeInBytes();
        long plaintextBytesToSkipInitially = startInclusive % (long)blockSize;
        long startingBlockNumberInclusive = startInclusive / (long)blockSize;
        long ciphertextStartPositionInclusive = startingBlockNumberInclusive * (long)blockSize;
        long endingBlockNumberInclusive = endInclusive / (long)blockSize;
        long ciphertextEndPositionInclusive = (endingBlockNumberInclusive + 1L) * (long)blockSize - 1L;
        long lengthOfPlaintextIncludingSkipBytes = endInclusive - startInclusive + (plaintextBytesToSkipInitially + 1L);
        return new ByteRangeConversion(ciphertextStartPositionInclusive, plaintextBytesToSkipInitially, ciphertextEndPositionInclusive, lengthOfPlaintextIncludingSkipBytes, startingBlockNumberInclusive);
    }

    @Override
    public AlgorithmParameterSpec getEncryptionParameterSpec(byte[] iv, long position) {
        Validate.notNull((Object)iv, (String)"Initialization vector must not be null", (Object[])new Object[0]);
        Validate.isTrue((iv.length == this.getIVLengthInBytes() ? 1 : 0) != 0, (String)"Initialization vector has the wrong byte count [%d] expected [%d] bytes", (Object[])new Object[]{iv.length, this.getIVLengthInBytes()});
        int ivLength = this.getIVLengthInBytes();
        int blockSize = this.getBlockSizeInBytes();
        long startingBlock = position / (long)blockSize;
        byte[] startingBlockArray = ByteBuffer.allocate(ivLength).putLong(8, startingBlock).array();
        byte[] updatedIV = new byte[ivLength];
        int carry = 0;
        for (int ivIndex = ivLength - 1; ivIndex >= 0; --ivIndex) {
            byte newIVByte;
            int newIVByteAsInt = (iv[ivIndex] & 0xFF) + (startingBlockArray[ivIndex] & 0xFF) + carry;
            carry = newIVByteAsInt >>> 8;
            updatedIV[ivIndex] = newIVByte = (byte)newIVByteAsInt;
        }
        return new IvParameterSpec(updatedIV);
    }

    @Override
    public long updateCipherToPosition(Cipher cipher, long position) {
        int blockSize = this.getBlockSizeInBytes();
        long block = position / (long)blockSize;
        long skip = position % (long)blockSize;
        byte[] throwaway = new byte[blockSize];
        for (long i = 0L; i < block; ++i) {
            cipher.update(throwaway);
        }
        return skip;
    }

    @Override
    public boolean supportsRandomAccess() {
        return true;
    }
}

