/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.DefaultHostPasswordStore;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.freedesktop.secret.simple.SimpleCollection;

public class LinuxPasswordStore
extends DefaultHostPasswordStore {
    private final String application = PreferencesFactory.get().getProperty("application.name");
    private final SimpleCollection keyring;

    public LinuxPasswordStore() throws FactoryException {
        try {
            this.keyring = new SimpleCollection();
        }
        catch (IOException e) {
            throw new FactoryException("Accessing secret-service DBus API failed");
        }
    }

    @Override
    public String getPassword(String serviceName, String accountName) {
        List list = this.keyring.getItems(this.createAttributes(String.format("%s@%s", accountName, serviceName)));
        if (list != null) {
            return String.valueOf(this.keyring.getSecret((String)list.get(0)));
        }
        return null;
    }

    @Override
    public void addPassword(String serviceName, String accountName, String password) {
        List list = this.keyring.getItems(this.createAttributes(password));
        if (list == null) {
            this.keyring.createItem(this.application, (CharSequence)password, this.createAttributes(String.format("%s@%s", accountName, serviceName)));
        }
    }

    @Override
    public String getPassword(Scheme scheme, int port, String hostname, String user) {
        List list = this.keyring.getItems(this.createAttributes(String.format("%s://%s@%s:%d", new Object[]{scheme, user, hostname, port})));
        if (list != null) {
            return String.valueOf(this.keyring.getSecret((String)list.get(0)));
        }
        return null;
    }

    @Override
    public void addPassword(Scheme scheme, int port, String hostname, String user, String password) {
        List list = this.keyring.getItems(this.createAttributes(password));
        if (list == null) {
            this.keyring.createItem(this.application, (CharSequence)password, this.createAttributes(String.format("%s://%s@%s:%d", new Object[]{scheme, user, hostname, port})));
        }
    }

    @Override
    public void deletePassword(String serviceName, String accountName) {
        List list = this.keyring.getItems(this.createAttributes(String.format("%s@%s", accountName, serviceName)));
        if (list != null) {
            this.keyring.deleteItems(list);
        }
    }

    @Override
    public void deletePassword(Scheme scheme, int port, String hostname, String user) {
        List list = this.keyring.getItems(this.createAttributes(String.format("%s://%s@%s:%d", new Object[]{scheme, user, hostname, port})));
        if (list != null) {
            this.keyring.deleteItems(list);
        }
    }

    private Map<String, String> createAttributes(String key) {
        return Collections.singletonMap("URI", key);
    }
}

