/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.Console;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferPrompt;
import java.util.Arrays;
import java.util.HashSet;

public class TerminalTransferPrompt
implements TransferPrompt {
    private final Console console = new Console();
    private final Transfer.Type transfer;

    public TerminalTransferPrompt(Transfer.Type transfer) {
        this.transfer = transfer;
    }

    @Override
    public TransferAction prompt(TransferItem item) {
        String input;
        StringBuilder actions = new StringBuilder().append("\n");
        HashSet<TransferAction> options = new HashSet<TransferAction>(TransferAction.forTransfer(this.transfer));
        options.add(TransferAction.cancel);
        for (TransferAction a : options) {
            actions.append("\t").append(a.getTitle()).append("\t").append(a.getDescription()).append(String.format(" (%s)", a.name())).append("\n");
        }
        try {
            switch (this.transfer) {
                case download: {
                    input = this.console.readLine("%nThe local file %s already exists. Choose what action to take:%n%s%nAction %s: ", item.local.getAbsolute(), actions, Arrays.toString(options.toArray()));
                    break;
                }
                case upload: 
                case move: 
                case copy: {
                    input = this.console.readLine("%nThe remote file %s already exists. Choose what action to take:%n%s%nAction %s: ", item.remote.getAbsolute(), actions, Arrays.toString(options.toArray()));
                    break;
                }
                case sync: {
                    input = this.console.readLine("%nChoose what action to take:%n%s%nAction %s: ", actions, Arrays.toString(options.toArray()));
                    break;
                }
                default: {
                    return TransferAction.cancel;
                }
            }
        }
        catch (ConnectionCanceledException e) {
            return TransferAction.cancel;
        }
        TransferAction action = TransferAction.forName(input);
        if (null == action) {
            return this.prompt(item);
        }
        return action;
    }

    @Override
    public boolean isSelected(TransferItem file) {
        return true;
    }

    @Override
    public void message(String message) {
        this.console.printf(message, new Object[0]);
    }
}

