/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.TerminalHelpFormatter;
import ch.cyberduck.core.BundledProtocolPredicate;
import ch.cyberduck.core.DefaultProtocolPredicate;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.ProfileProtocolPredicate;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.aquaticprime.DisabledLicenseVerifierCallback;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.LicenseFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;

public final class TerminalHelpPrinter {
    private TerminalHelpPrinter() {
    }

    public static void print(Options options) {
        TerminalHelpPrinter.print(options, new TerminalHelpFormatter());
    }

    public static void print(Options options, HelpFormatter formatter) {
        formatter.setSyntaxPrefix("Usage:");
        Preferences preferences = PreferencesFactory.get();
        StringBuilder builder = new StringBuilder().append("Default protocols").append("\n");
        ProtocolFactory protocols = ProtocolFactory.get();
        for (Protocol p : protocols.find(new DefaultProtocolPredicate(EnumSet.of(Protocol.Type.ftp, Protocol.Type.sftp, Protocol.Type.dav)))) {
            TerminalHelpPrinter.append(p, builder);
        }
        builder.append("\n");
        for (Protocol p : protocols.find(new DefaultProtocolPredicate(EnumSet.of(Protocol.Type.s3, Protocol.Type.swift, Protocol.Type.azure, Protocol.Type.b2, Protocol.Type.googlestorage)))) {
            TerminalHelpPrinter.append(p, builder);
        }
        builder.append("\n");
        for (Protocol p : protocols.find(new DefaultProtocolPredicate(EnumSet.of(Protocol.Type.dropbox, Protocol.Type.onedrive, Protocol.Type.googledrive, Protocol.Type.dracoon)))) {
            TerminalHelpPrinter.append(p, builder);
        }
        builder.append("Local Disk");
        builder.append("\n");
        for (Protocol p : protocols.find(new DefaultProtocolPredicate(EnumSet.of(Protocol.Type.file)))) {
            TerminalHelpPrinter.append(p, builder);
        }
        builder.append("\n");
        builder.append(String.format("Third party connection profiles. Install additional connection profiles in %s", LocalFactory.get(SupportDirectoryFinderFactory.get().find(), PreferencesFactory.get().getProperty("profiles.folder.name")).getAbbreviatedPath()));
        builder.append("\n");
        for (Protocol p : protocols.find(new ProfileProtocolPredicate())) {
            TerminalHelpPrinter.append(p, builder);
        }
        StringBuilder header = new StringBuilder("\n").append("\t").append("URLs must be fully qualified. Paths can either denote a remote file (ftps://user@example.net/resource) or folder (ftps://user@example.net/directory/) with a trailing slash. You can reference files relative to your home directory with /~ (ftps://user@example.net/~/).").append("\n").append((CharSequence)builder).append("\n").append("\n");
        StringBuilder footer = new StringBuilder("\n");
        footer.append(String.format("Cyberduck is libre software licenced under the GPL. For general help about using Cyberduck, please refer to %s and the wiki at %s. For bug reports or feature requests open a ticket at %s.", preferences.getProperty("website.cli"), preferences.getProperty("website.help"), MessageFormat.format(preferences.getProperty("website.bug"), preferences.getProperty("application.version"))));
        License l = LicenseFactory.find();
        footer.append("\n");
        if (l.verify(new DisabledLicenseVerifierCallback())) {
            footer.append(l.toString());
        } else {
            footer.append("Not registered. Purchase a donation key to support the development of this software.");
        }
        formatter.printHelp("duck [options...]", header.toString(), options, footer.toString());
    }

    private static void append(Protocol protocol, StringBuilder builder) {
        String format = "%s:";
        if (protocol.isHostnameConfigurable()) {
            format = StringUtils.isBlank((CharSequence)protocol.getDefaultHostname()) ? format + "//<hostname>" : format + "(//<hostname>)";
        }
        switch (protocol.getType()) {
            case b2: 
            case s3: 
            case googlestorage: 
            case swift: 
            case azure: {
                format = format + "/<container>/<key>";
                break;
            }
            default: {
                format = format + "/<folder>/<file>";
            }
        }
        String url = String.format(format, TerminalHelpPrinter.getScheme(protocol));
        builder.append(String.format("%s %s", StringUtils.leftPad((String)protocol.getDescription(), (int)50), url)).append("\n");
    }

    protected static String getScheme(Protocol protocol) {
        if (new BundledProtocolPredicate().test(protocol)) {
            int n = 0;
            String[] stringArray = protocol.getSchemes();
            int n2 = stringArray.length;
            if (n < n2) {
                String scheme = stringArray[n];
                return scheme;
            }
            return protocol.getIdentifier();
        }
        Protocol standard = ProtocolFactory.get().forName(protocol.getIdentifier());
        if (Arrays.equals(protocol.getSchemes(), standard.getSchemes())) {
            return protocol.getProvider();
        }
        int n = 0;
        String[] stringArray = protocol.getSchemes();
        int n3 = stringArray.length;
        if (n < n3) {
            String scheme = stringArray[n];
            return scheme;
        }
        return protocol.getProvider();
    }
}

