/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer.impl.jna;

import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSEnumerator;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSString;
import ch.cyberduck.core.serializer.Deserializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.rococoa.ObjCClass;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;

public class PlistDeserializer
implements Deserializer<NSDictionary> {
    private static final Logger log = Logger.getLogger(PlistDeserializer.class);
    final NSDictionary dict;

    public PlistDeserializer(NSDictionary dict) {
        this.dict = dict;
    }

    public String stringForKey(String key) {
        NSObject value = this.dict.objectForKey(key);
        if (null == value) {
            return null;
        }
        return value.toString();
    }

    public boolean booleanForKey(String key) {
        String value = this.stringForKey(key);
        if (null == value) {
            return false;
        }
        return value.equalsIgnoreCase(String.valueOf(1));
    }

    public List<String> keys() {
        NSObject next;
        NSArray array = this.dict.allKeys();
        NSEnumerator enumerator = array.objectEnumerator();
        ArrayList<String> keys = new ArrayList<String>();
        while ((next = enumerator.nextObject()) != null) {
            if (!next.isKindOfClass((ObjCClass)NSString.CLASS)) continue;
            keys.add(((NSString)Rococoa.cast((ObjCObject)next, NSString.class)).toString());
        }
        return keys;
    }

    public NSDictionary objectForKey(String key) {
        NSObject value = this.dict.objectForKey(key);
        if (null == value) {
            return null;
        }
        if (value.isKindOfClass((ObjCClass)NSDictionary.CLASS)) {
            return (NSDictionary)Rococoa.cast((ObjCObject)value, NSDictionary.class);
        }
        log.warn((Object)String.format("Unexpected value type for serialized key %s", key));
        return null;
    }

    public <T> List<T> listForKey(String key) {
        NSObject value = this.dict.objectForKey(key);
        if (null == value) {
            return null;
        }
        if (value.isKindOfClass((ObjCClass)NSArray.CLASS)) {
            NSObject next;
            NSArray array = (NSArray)Rococoa.cast((ObjCObject)value, NSArray.class);
            NSEnumerator enumerator = array.objectEnumerator();
            ArrayList<Object> list = new ArrayList<Object>();
            while ((next = enumerator.nextObject()) != null) {
                if (next.isKindOfClass((ObjCClass)NSDictionary.CLASS)) {
                    list.add(Rococoa.cast((ObjCObject)next, NSDictionary.class));
                }
                if (!next.isKindOfClass((ObjCClass)NSString.CLASS)) continue;
                list.add(((NSString)Rococoa.cast((ObjCObject)next, NSString.class)).toString());
            }
            return list;
        }
        log.warn((Object)String.format("Unexpected value type for serialized key %s", key));
        return null;
    }

    public Map<String, String> mapForKey(String key) {
        NSObject value = this.dict.objectForKey(key);
        if (null == value) {
            return null;
        }
        if (value.isKindOfClass((ObjCClass)NSArray.CLASS)) {
            NSObject next;
            NSDictionary dict = (NSDictionary)Rococoa.cast((ObjCObject)value, NSDictionary.class);
            NSEnumerator enumerator = dict.allKeys().objectEnumerator();
            HashMap<String, String> list = new HashMap<String, String>();
            while ((next = enumerator.nextObject()) != null) {
                String k = ((NSString)Rococoa.cast((ObjCObject)next, NSString.class)).toString();
                list.put(k, ((NSString)Rococoa.cast((ObjCObject)dict.objectForKey(k), NSString.class)).toString());
            }
            return list;
        }
        log.warn((Object)String.format("Unexpected value type for serialized key %s", key));
        return null;
    }
}

