/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.impl.jna.PlistDeserializer;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class Transmit5BookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static final Logger log = Logger.getLogger(Transmit5BookmarkCollection.class);
    private static final long serialVersionUID = 2422398644582883578L;

    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.transmit5.location"));
    }

    public String getBundleIdentifier() {
        return "com.panic.Transmit";
    }

    public String getName() {
        return "Transmit 5";
    }

    public String getConfiguration() {
        return String.format("bookmark.import.%s%d", this.getBundleIdentifier(), 5);
    }

    protected void parse(ProtocolFactory protocols, Local folder) throws AccessDeniedException {
        for (Local f : folder.list().filter((Filter)new NullFilter<Local>(){

            public boolean accept(Local file) {
                if (file.isFile()) {
                    return "favoriteMetadata".equals(file.getExtension());
                }
                return false;
            }
        })) {
            this.read(protocols, f);
        }
    }

    protected void read(ProtocolFactory protocols, Local file) throws LocalAccessDeniedException {
        Protocol protocol;
        NSDictionary serialized = NSDictionary.dictionaryWithContentsOfFile((String)file.getAbsolute());
        if (null == serialized) {
            throw new LocalAccessDeniedException(String.format("Invalid bookmark file %s", file));
        }
        PlistDeserializer bookmark = new PlistDeserializer(serialized);
        String identifier = bookmark.stringForKey("com_panic_transmit_protocol");
        if (StringUtils.isBlank((CharSequence)identifier)) {
            log.warn((Object)"Missing key com_panic_transmit_protocol");
            return;
        }
        String hostname = bookmark.stringForKey("com_panic_transmit_server");
        if (StringUtils.isBlank((CharSequence)hostname)) {
            log.warn((Object)"Missing key com_panic_transmit_server");
            return;
        }
        switch (identifier) {
            case "FTP": 
            case "FTP with Implicit SSL": 
            case "FTP with TLS/SSL": {
                protocol = protocols.forType(Protocol.Type.ftp);
                break;
            }
            case "SFTP": {
                protocol = protocols.forType(Protocol.Type.sftp);
                break;
            }
            case "WebDAV": 
            case "WebDAV HTTPS": {
                protocol = protocols.forType(Protocol.Type.dav);
                break;
            }
            case "OpenStack Swift": 
            case "Rackspace Cloud Files": {
                protocol = protocols.forType(Protocol.Type.swift);
                break;
            }
            case "Backblaze B2": {
                protocol = protocols.forType(Protocol.Type.b2);
                break;
            }
            case "Amazon S3": {
                protocol = protocols.forType(Protocol.Type.s3);
                break;
            }
            case "Dropbox": {
                protocol = protocols.forType(Protocol.Type.dropbox);
                break;
            }
            case "Google Drive": {
                protocol = protocols.forType(Protocol.Type.googledrive);
                break;
            }
            case "Microsoft Azure": {
                protocol = protocols.forType(Protocol.Type.azure);
                break;
            }
            case "Microsoft OneDrive": 
            case "Microsoft OneDrive for Business": {
                protocol = protocols.forType(Protocol.Type.onedrive);
                break;
            }
            default: {
                protocol = null;
            }
        }
        if (null == protocol) {
            log.warn((Object)String.format("Unable to determine protocol for %s", identifier));
            return;
        }
        Host host = new Host(protocol, hostname, new Credentials(bookmark.stringForKey("com_panic_transmit_username")));
        host.setNickname(bookmark.stringForKey("com_panic_transmit_nickname"));
        host.setDefaultPath(bookmark.stringForKey("com_panic_transmit_remotePath"));
        String port = bookmark.stringForKey("com_panic_transmit_port");
        if (StringUtils.isNotBlank((CharSequence)port)) {
            try {
                host.setPort(Integer.parseInt(port));
            }
            catch (NumberFormatException e) {
                log.warn((Object)String.format("Ignore invalid port number %s", port));
            }
        }
        this.add(host);
    }
}

