/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature.crypto;

import com.squareup.jnagmp.Gmp;
import com.squareup.jnagmp.GmpInteger;
import java.math.BigInteger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class MantaNativeRSACoreEngine {
    private RSAKeyParameters key;
    private boolean forEncryption;
    private boolean isPrivate;
    private boolean isSmallExponent;
    private GmpInteger p;
    private GmpInteger q;
    private GmpInteger dP;
    private GmpInteger dQ;
    private BigInteger qInv;
    private GmpInteger exponent;
    private GmpInteger modulus;

    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RSAKeyParameters)rParam.getParameters();
        } else {
            this.key = (RSAKeyParameters)param;
        }
        this.forEncryption = forEncryption;
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            this.isPrivate = true;
            RSAPrivateCrtKeyParameters crtKey = (RSAPrivateCrtKeyParameters)this.key;
            this.p = new GmpInteger(crtKey.getP());
            this.q = new GmpInteger(crtKey.getQ());
            this.dP = new GmpInteger(crtKey.getDP());
            this.dQ = new GmpInteger(crtKey.getDQ());
            this.qInv = crtKey.getQInv();
            this.modulus = null;
            this.exponent = null;
        } else {
            this.isPrivate = false;
            this.exponent = new GmpInteger(this.key.getExponent());
            this.modulus = new GmpInteger(this.key.getModulus());
            this.isSmallExponent = this.exponent.bitLength() < 64;
            this.dQ = null;
            this.dP = null;
            this.q = null;
            this.p = null;
            this.qInv = null;
        }
    }

    public int getInputBlockSize() {
        int bitSize = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (bitSize + 7) / 8 - 1;
        }
        return (bitSize + 7) / 8;
    }

    public int getOutputBlockSize() {
        int bitSize = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (bitSize + 7) / 8;
        }
        return (bitSize + 7) / 8 - 1;
    }

    public BigInteger convertInput(byte[] in, int inOff, int inLen) {
        byte[] block;
        if (inLen > this.getInputBlockSize() + 1) {
            throw new DataLengthException("input too large for RSA cipher.");
        }
        if (inLen == this.getInputBlockSize() + 1 && !this.forEncryption) {
            throw new DataLengthException("input too large for RSA cipher.");
        }
        if (inOff != 0 || inLen != in.length) {
            block = new byte[inLen];
            System.arraycopy(in, inOff, block, 0, inLen);
        } else {
            block = in;
        }
        BigInteger res = new BigInteger(1, block);
        if (res.compareTo(this.key.getModulus()) >= 0) {
            throw new DataLengthException("input too large for RSA cipher.");
        }
        return res;
    }

    public byte[] convertOutput(BigInteger result) {
        byte[] output = result.toByteArray();
        if (this.forEncryption) {
            if (output[0] == 0 && output.length > this.getOutputBlockSize()) {
                byte[] tmp = new byte[output.length - 1];
                System.arraycopy(output, 1, tmp, 0, tmp.length);
                return tmp;
            }
            if (output.length < this.getOutputBlockSize()) {
                byte[] tmp = new byte[this.getOutputBlockSize()];
                System.arraycopy(output, 0, tmp, tmp.length - output.length, output.length);
                return tmp;
            }
        } else if (output[0] == 0) {
            byte[] tmp = new byte[output.length - 1];
            System.arraycopy(output, 1, tmp, 0, tmp.length);
            return tmp;
        }
        return output;
    }

    public BigInteger processBlock(BigInteger input) {
        if (this.isPrivate) {
            BigInteger mP = Gmp.modPowSecure((BigInteger)input.remainder((BigInteger)this.p), (BigInteger)this.dP, (BigInteger)this.p);
            BigInteger mQ = Gmp.modPowSecure((BigInteger)input.remainder((BigInteger)this.q), (BigInteger)this.dQ, (BigInteger)this.q);
            BigInteger h = mP.subtract(mQ);
            h = h.multiply(this.qInv);
            h = h.mod((BigInteger)this.p);
            BigInteger m = h.multiply((BigInteger)this.q);
            m = m.add(mQ);
            return m;
        }
        if (this.isSmallExponent) {
            return Gmp.modPowInsecure((BigInteger)input, (BigInteger)this.exponent, (BigInteger)this.modulus);
        }
        return Gmp.modPowSecure((BigInteger)input, (BigInteger)this.exponent, (BigInteger)this.modulus);
    }
}

