/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature.apache.httpclient;

import com.joyent.http.signature.apache.httpclient.HttpSignatureAuthScheme;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.Credentials;
import org.apache.http.protocol.HttpContext;

public class HttpSignatureRequestInterceptor
implements HttpRequestInterceptor {
    private final boolean authEnabled;
    private final HttpSignatureAuthScheme authScheme;
    private final Credentials credentials;

    public HttpSignatureRequestInterceptor(HttpSignatureAuthScheme authScheme, Credentials credentials, boolean authEnabled) {
        this.authScheme = authScheme;
        this.credentials = credentials;
        this.authEnabled = authEnabled;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (!this.authEnabled) {
            return;
        }
        long start = System.nanoTime();
        Header authorization = this.authScheme.authenticate(this.credentials, request, context);
        long end = System.nanoTime();
        request.setHeader(authorization);
        request.setHeader("x-http-signing-time-ns", String.valueOf(end - start));
    }
}

