/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveIdentity;
import org.nuxeo.onedrive.client.OneDriveJsonObject;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

public class OneDriveIdentitySet
extends OneDriveJsonObject {
    private OneDriveIdentity user;
    private OneDriveIdentity application;
    private OneDriveIdentity device;

    public OneDriveIdentitySet(JsonObject json) {
        super(json);
    }

    public OneDriveIdentity getUser() {
        return this.user;
    }

    public OneDriveIdentity getApplication() {
        return this.application;
    }

    public OneDriveIdentity getDevice() {
        return this.device;
    }

    @Override
    protected void parseMember(JsonObject.Member member) {
        super.parseMember(member);
        try {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if ("user".equals(memberName)) {
                this.user = new OneDriveIdentity(value.asObject());
            } else if ("application".equals(memberName)) {
                this.application = new OneDriveIdentity(value.asObject());
            } else if ("device".equals(memberName)) {
                this.device = new OneDriveIdentity(value.asObject());
            }
        }
        catch (ParseException e) {
            throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
        }
    }
}

