/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.azure.AzureExceptionMappingService;
import ch.cyberduck.core.azure.AzurePathContainerService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AzureMetadataFeature
implements Headers {
    private final AzureSession session;
    private final OperationContext context;
    private final PathContainerService containerService = new AzurePathContainerService();

    public AzureMetadataFeature(AzureSession session, OperationContext context) {
        this.session = session;
        this.context = context;
    }

    public Map<String, String> getDefault(Local local) {
        return PreferencesFactory.get().getMap("azure.metadata.default");
    }

    public Map<String, String> getMetadata(Path file) throws BackgroundException {
        try {
            if (this.containerService.isContainer(file)) {
                CloudBlobContainer container = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName());
                container.downloadAttributes();
                return container.getMetadata();
            }
            CloudBlob blob = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getBlobReferenceFromServer(this.containerService.getKey(file));
            blob.downloadAttributes(null, null, this.context);
            HashMap<String, String> metadata = new HashMap<String, String>(blob.getMetadata());
            BlobProperties properties = blob.getProperties();
            if (StringUtils.isNotBlank((CharSequence)properties.getCacheControl())) {
                metadata.put("Cache-Control", properties.getCacheControl());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getContentType())) {
                metadata.put("Content-Type", properties.getContentType());
            }
            return metadata;
        }
        catch (URISyntaxException e) {
            throw new NotfoundException(e.getMessage(), (Throwable)e);
        }
        catch (StorageException e) {
            throw new AzureExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public void setMetadata(Path file, TransferStatus status) throws BackgroundException {
        try {
            BlobRequestOptions options = new BlobRequestOptions();
            if (this.containerService.isContainer(file)) {
                CloudBlobContainer container = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName());
                container.setMetadata(new HashMap(status.getMetadata()));
                container.uploadMetadata(AccessCondition.generateEmptyCondition(), options, this.context);
            } else {
                CloudBlob blob = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getBlobReferenceFromServer(this.containerService.getKey(file));
                blob.downloadAttributes();
                HashMap<String, String> pruned = new HashMap<String, String>();
                for (Map.Entry m : status.getMetadata().entrySet()) {
                    BlobProperties properties = blob.getProperties();
                    if ("Cache-Control".equalsIgnoreCase((String)m.getKey())) {
                        properties.setCacheControl((String)m.getValue());
                        continue;
                    }
                    if ("Content-Type".equalsIgnoreCase((String)m.getKey())) {
                        properties.setContentType((String)m.getValue());
                        continue;
                    }
                    pruned.put((String)m.getKey(), (String)m.getValue());
                }
                blob.setMetadata(pruned);
                blob.uploadMetadata(AccessCondition.generateEmptyCondition(), options, this.context);
                blob.uploadProperties();
            }
        }
        catch (URISyntaxException e) {
            throw new NotfoundException(e.getMessage(), (Throwable)e);
        }
        catch (StorageException e) {
            throw new AzureExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }
}

