/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.networking;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import com.google.common.escape.Escaper;
import com.spectralogic.ds3client.BulkCommand;
import com.spectralogic.ds3client.networking.ConnectionDetails;
import com.spectralogic.ds3client.utils.Guard;
import com.spectralogic.ds3client.utils.SafeStringManipulation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public final class NetUtils {
    private NetUtils() {
        throw new IllegalStateException("This component should never be initialized.");
    }

    public static URL buildUrl(ConnectionDetails connectionDetails, String path) throws MalformedURLException {
        return NetUtils.buildUrl(connectionDetails, path, null);
    }

    public static URL buildUrl(ConnectionDetails connectionDetails, String path, Map<String, String> params) throws MalformedURLException {
        StringBuilder builder = new StringBuilder();
        if (!connectionDetails.getEndpoint().startsWith("http")) {
            builder.append(connectionDetails.isHttps() ? "https" : "http").append("://");
        }
        builder.append(connectionDetails.getEndpoint());
        if (!path.startsWith("/")) {
            builder.append('/');
        }
        Escaper urlEscaper = SafeStringManipulation.getDs3Escaper();
        builder.append(urlEscaper.escape(path));
        if (params != null && params.size() > 0) {
            builder.append('?');
            builder.append(urlEscaper.escape(NetUtils.buildQueryString(params)));
        }
        return new URL(builder.toString());
    }

    public static String buildQueryString(Map<String, String> queryParams) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(queryParams);
        Iterator stringIter = Iterators.transform(sortedMap.entrySet().iterator(), (Function)new Function<Map.Entry<String, String>, String>(){

            public String apply(@Nonnull Map.Entry<String, String> input) {
                if (Guard.isStringNullOrEmpty((String)input.getValue())) {
                    return input.getKey();
                }
                return input.getKey() + "=" + input.getValue();
            }
        });
        Joiner join = Joiner.on((char)'&');
        return join.join(stringIter);
    }

    public static String buildPath(String basePath, String path) {
        if (basePath == null && path == null) {
            return "";
        }
        if (basePath == null) {
            return path;
        }
        if (path == null) {
            return basePath;
        }
        StringBuilder builder = new StringBuilder();
        if (!basePath.startsWith("/")) {
            builder.append('/');
        }
        builder.append(basePath);
        if (!path.startsWith("/") && !basePath.endsWith("/")) {
            builder.append('/');
        }
        if (path.startsWith("/") && basePath.endsWith("/")) {
            builder.append(path.substring(1));
        } else {
            builder.append(path);
        }
        return builder.toString();
    }

    public static URL buildBucketPath(String bucketName, ConnectionDetails connectionDetails, BulkCommand command) throws MalformedURLException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("operation", command.toString());
        return NetUtils.buildUrl(connectionDetails, NetUtils.bucketPath(bucketName), queryParams);
    }

    private static String bucketPath(String bucket) {
        return "/_rest_/buckets/" + bucket;
    }

    public static String buildHostField(ConnectionDetails details) {
        return NetUtils.filterHttp(details.getEndpoint());
    }

    public static String filterHttp(String url) {
        if (url.startsWith("http://") || url.startsWith("https://")) {
            int colonIndex = url.indexOf(":");
            return url.substring(colonIndex + 3);
        }
        return url;
    }

    public static int getPort(URL url) {
        int port = url.getPort();
        if (port > 0) {
            return port;
        }
        if (url.getProtocol().equals("https")) {
            return 443;
        }
        return 80;
    }
}

