/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.transferstrategy;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.spectralogic.ds3client.commands.GetObjectRequest;
import com.spectralogic.ds3client.commands.GetObjectResponse;
import com.spectralogic.ds3client.helpers.JobPart;
import com.spectralogic.ds3client.helpers.strategy.StrategyUtils;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.ChannelStrategy;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.EventDispatcher;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferMethod;
import com.spectralogic.ds3client.models.BulkObject;
import com.spectralogic.ds3client.models.common.Range;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;

public class GetJobTransferMethod
implements TransferMethod {
    private final ChannelStrategy channelStrategy;
    private final String bucketName;
    private final String jobId;
    private final EventDispatcher eventDispatcher;
    private final ImmutableMap<String, ImmutableMultimap<BulkObject, Range>> rangesForBlobs;

    public GetJobTransferMethod(ChannelStrategy channelStrategy, String bucketName, String jobId, EventDispatcher eventDispatcher, ImmutableMap<String, ImmutableMultimap<BulkObject, Range>> rangesForBlobs) {
        this.channelStrategy = channelStrategy;
        this.bucketName = bucketName;
        this.jobId = jobId;
        this.eventDispatcher = eventDispatcher;
        this.rangesForBlobs = rangesForBlobs;
    }

    @Override
    public void transferJobPart(JobPart jobPart) throws IOException {
        SeekableByteChannel seekableByteChannel = this.channelStrategy.acquireChannelForBlob(jobPart.getBlob());
        GetObjectResponse getObjectResponse = jobPart.getClient().getObject(this.makeGetObjectRequest(seekableByteChannel, jobPart));
        BulkObject blob = jobPart.getBlob();
        this.channelStrategy.releaseChannelForBlob(seekableByteChannel, blob);
        this.eventDispatcher.emitChecksumEvent(blob, getObjectResponse.getChecksumType(), getObjectResponse.getChecksum());
        this.eventDispatcher.emitMetaDataReceivedEvent(blob.getName(), getObjectResponse.getMetadata());
        this.eventDispatcher.emitBlobTransferredEvent(blob);
        this.eventDispatcher.emitDataTransferredEvent(blob);
    }

    private GetObjectRequest makeGetObjectRequest(SeekableByteChannel seekableByteChannel, JobPart jobPart) {
        ImmutableCollection<Range> rangesForBlob;
        BulkObject blob = jobPart.getBlob();
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, blob.getName(), (WritableByteChannel)seekableByteChannel, this.jobId, blob.getOffset());
        if (jobPart.getBlob().getVersionId() != null) {
            getObjectRequest.withVersionId(jobPart.getBlob().getVersionId());
        }
        if ((rangesForBlob = StrategyUtils.getRangesForBlob(this.rangesForBlobs, blob)) != null) {
            getObjectRequest.withByteRanges((Collection<Range>)rangesForBlob);
        }
        return getObjectRequest;
    }
}

