/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.pagination;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationResponse;
import com.spectralogic.ds3client.helpers.pagination.PaginatingCommand;
import com.spectralogic.ds3client.networking.FailedRequestException;
import com.spectralogic.ds3client.networking.TooManyRetriesException;
import com.spectralogic.ds3client.utils.collections.LazyIterable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class SpectraS3PaginationLoader<T, E extends AbstractPaginationRequest, F extends AbstractPaginationResponse>
implements LazyIterable.LazyLoader<T> {
    private final PaginatingCommand<T, E, F> paginatingCommand;
    private final int pageLength;
    private final int retries;
    private int pageOffset = 0;
    private int pagingTotalResultCount;
    private int totalItems = 0;

    public SpectraS3PaginationLoader(PaginatingCommand<T, E, F> paginatingCommand, int pageLength, int retries) {
        this.paginatingCommand = paginatingCommand;
        this.pageLength = pageLength;
        this.retries = retries;
    }

    @Override
    public List<T> getNextValues() {
        int retryAttempt = 0;
        while (this.totalItems <= 0 || this.totalItems < this.pagingTotalResultCount) {
            E request = this.paginatingCommand.createRequest();
            request.withPageLength(this.pageLength).withPageOffset(this.pageOffset * this.pageLength);
            try {
                F response = this.paginatingCommand.invokeCommand(request);
                this.pagingTotalResultCount = ((AbstractPaginationResponse)response).getPagingTotalResultCount();
                List<T> newValues = this.paginatingCommand.getResponseContents(response);
                this.totalItems += newValues.size();
                ++this.pageOffset;
                return newValues;
            }
            catch (FailedRequestException e) {
                throw new RuntimeException("Encountered a failure when attempting to get object list", e);
            }
            catch (IOException e) {
                if (retryAttempt >= this.retries) {
                    throw new TooManyRetriesException("Failed to get the next set of objects from the getBucket request after " + this.retries + " retries", e);
                }
                ++retryAttempt;
                continue;
            }
            break;
        }
        return Collections.emptyList();
    }
}

