/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class RawImportAllTapesSpectraS3Request
extends AbstractRequest {
    private final String bucketId;
    private String storageDomainId;
    private Priority taskPriority;

    public RawImportAllTapesSpectraS3Request(String bucketId) {
        this.bucketId = bucketId;
        this.getQueryParams().put("operation", "import");
        this.updateQueryParam("bucket_id", bucketId);
    }

    public RawImportAllTapesSpectraS3Request withStorageDomainId(UUID storageDomainId) {
        this.storageDomainId = storageDomainId.toString();
        this.updateQueryParam("storage_domain_id", storageDomainId);
        return this;
    }

    public RawImportAllTapesSpectraS3Request withStorageDomainId(String storageDomainId) {
        this.storageDomainId = storageDomainId;
        this.updateQueryParam("storage_domain_id", storageDomainId);
        return this;
    }

    public RawImportAllTapesSpectraS3Request withTaskPriority(Priority taskPriority) {
        this.taskPriority = taskPriority;
        this.updateQueryParam("task_priority", taskPriority);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape";
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getStorageDomainId() {
        return this.storageDomainId;
    }

    public Priority getTaskPriority() {
        return this.taskPriority;
    }
}

