/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.StorageDomainMemberState;
import com.spectralogic.ds3client.models.WritePreferenceLevel;
import com.spectralogic.ds3client.networking.HttpVerb;

public class ModifyStorageDomainMemberSpectraS3Request
extends AbstractRequest {
    private final String storageDomainMember;
    private Integer autoCompactionThreshold;
    private StorageDomainMemberState state;
    private WritePreferenceLevel writePreference;

    public ModifyStorageDomainMemberSpectraS3Request(String storageDomainMember) {
        this.storageDomainMember = storageDomainMember;
    }

    public ModifyStorageDomainMemberSpectraS3Request withAutoCompactionThreshold(Integer autoCompactionThreshold) {
        this.autoCompactionThreshold = autoCompactionThreshold;
        this.updateQueryParam("auto_compaction_threshold", autoCompactionThreshold);
        return this;
    }

    public ModifyStorageDomainMemberSpectraS3Request withState(StorageDomainMemberState state) {
        this.state = state;
        this.updateQueryParam("state", state);
        return this;
    }

    public ModifyStorageDomainMemberSpectraS3Request withWritePreference(WritePreferenceLevel writePreference) {
        this.writePreference = writePreference;
        this.updateQueryParam("write_preference", writePreference);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/storage_domain_member/" + this.storageDomainMember;
    }

    public String getStorageDomainMember() {
        return this.storageDomainMember;
    }

    public Integer getAutoCompactionThreshold() {
        return this.autoCompactionThreshold;
    }

    public StorageDomainMemberState getState() {
        return this.state;
    }

    public WritePreferenceLevel getWritePreference() {
        return this.writePreference;
    }
}

