/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetSuspectBlobTapesSpectraS3Request
extends AbstractPaginationRequest {
    private String blobId;
    private boolean lastPage;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;
    private String tapeId;

    public GetSuspectBlobTapesSpectraS3Request withBlobId(UUID blobId) {
        this.blobId = blobId.toString();
        this.updateQueryParam("blob_id", blobId);
        return this;
    }

    public GetSuspectBlobTapesSpectraS3Request withBlobId(String blobId) {
        this.blobId = blobId;
        this.updateQueryParam("blob_id", blobId);
        return this;
    }

    public GetSuspectBlobTapesSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetSuspectBlobTapesSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetSuspectBlobTapesSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetSuspectBlobTapesSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetSuspectBlobTapesSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetSuspectBlobTapesSpectraS3Request withTapeId(UUID tapeId) {
        this.tapeId = tapeId.toString();
        this.updateQueryParam("tape_id", tapeId);
        return this;
    }

    public GetSuspectBlobTapesSpectraS3Request withTapeId(String tapeId) {
        this.tapeId = tapeId;
        this.updateQueryParam("tape_id", tapeId);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/suspect_blob_tape";
    }

    public String getBlobId() {
        return this.blobId;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }

    public String getTapeId() {
        return this.tapeId;
    }
}

