/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.models.JobChunkClientProcessingOrderGuarantee;
import com.spectralogic.ds3client.models.JobRequestType;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.Date;
import java.util.UUID;

public class GetCanceledJobsSpectraS3Request
extends AbstractPaginationRequest {
    private String bucketId;
    private boolean canceledDueToTimeout;
    private JobChunkClientProcessingOrderGuarantee chunkClientProcessingOrderGuarantee;
    private boolean lastPage;
    private String name;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;
    private Priority priority;
    private Date rechunked;
    private JobRequestType requestType;
    private boolean truncated;
    private String userId;

    public GetCanceledJobsSpectraS3Request withBucketId(String bucketId) {
        this.bucketId = bucketId;
        this.updateQueryParam("bucket_id", bucketId);
        return this;
    }

    public GetCanceledJobsSpectraS3Request withCanceledDueToTimeout(boolean canceledDueToTimeout) {
        this.canceledDueToTimeout = canceledDueToTimeout;
        this.updateQueryParam("canceled_due_to_timeout", canceledDueToTimeout);
        return this;
    }

    public GetCanceledJobsSpectraS3Request withChunkClientProcessingOrderGuarantee(JobChunkClientProcessingOrderGuarantee chunkClientProcessingOrderGuarantee) {
        this.chunkClientProcessingOrderGuarantee = chunkClientProcessingOrderGuarantee;
        this.updateQueryParam("chunk_client_processing_order_guarantee", chunkClientProcessingOrderGuarantee);
        return this;
    }

    public GetCanceledJobsSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetCanceledJobsSpectraS3Request withName(String name) {
        this.name = name;
        this.updateQueryParam("name", name);
        return this;
    }

    public GetCanceledJobsSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetCanceledJobsSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetCanceledJobsSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetCanceledJobsSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetCanceledJobsSpectraS3Request withPriority(Priority priority) {
        this.priority = priority;
        this.updateQueryParam("priority", priority);
        return this;
    }

    public GetCanceledJobsSpectraS3Request withRechunked(Date rechunked) {
        this.rechunked = rechunked;
        this.updateQueryParam("rechunked", rechunked);
        return this;
    }

    public GetCanceledJobsSpectraS3Request withRequestType(JobRequestType requestType) {
        this.requestType = requestType;
        this.updateQueryParam("request_type", requestType);
        return this;
    }

    public GetCanceledJobsSpectraS3Request withTruncated(boolean truncated) {
        this.truncated = truncated;
        this.updateQueryParam("truncated", truncated);
        return this;
    }

    public GetCanceledJobsSpectraS3Request withUserId(UUID userId) {
        this.userId = userId.toString();
        this.updateQueryParam("user_id", userId);
        return this;
    }

    public GetCanceledJobsSpectraS3Request withUserId(String userId) {
        this.userId = userId;
        this.updateQueryParam("user_id", userId);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/canceled_job";
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public boolean getCanceledDueToTimeout() {
        return this.canceledDueToTimeout;
    }

    public JobChunkClientProcessingOrderGuarantee getChunkClientProcessingOrderGuarantee() {
        return this.chunkClientProcessingOrderGuarantee;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public String getName() {
        return this.name;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public Date getRechunked() {
        return this.rechunked;
    }

    public JobRequestType getRequestType() {
        return this.requestType;
    }

    public boolean getTruncated() {
        return this.truncated;
    }

    public String getUserId() {
        return this.userId;
    }
}

