/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.DeleteObjectsResponse;
import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.models.DeleteResult;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class DeleteObjectsResponseParser
extends AbstractResponseParser<DeleteObjectsResponse> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public DeleteObjectsResponse parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        DeleteResult result = XmlOutput.fromXml(inputStream, DeleteResult.class);
                        DeleteObjectsResponse deleteObjectsResponse = new DeleteObjectsResponse(result, this.getChecksum(), this.getChecksumType());
                        return deleteObjectsResponse;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

