/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client;

import com.spectralogic.ds3client.commands.GetObjectResponse;
import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.interfaces.GetObjectCustomParserParameters;
import com.spectralogic.ds3client.commands.parsers.utils.Function;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.networking.WebResponse;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;

class GetObjectCustomParser
extends AbstractResponseParser<GetObjectResponse> {
    private final int[] expectedStatusCodes = new int[]{200, 206};
    private final WritableByteChannel destinationChannel;
    private final int bufferSize;
    private final String objectName;
    private final Function<GetObjectCustomParserParameters, GetObjectResponse> parsingFunction;

    public GetObjectCustomParser(WritableByteChannel destinationChannel, int bufferSize, String objectName, Function<GetObjectCustomParserParameters, GetObjectResponse> parsingFunction) {
        this.destinationChannel = destinationChannel;
        this.bufferSize = bufferSize;
        this.objectName = objectName;
        this.parsingFunction = parsingFunction;
    }

    @Override
    public GetObjectResponse parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            GetObjectCustomParserParameters params = new GetObjectCustomParserParameters(response, this.destinationChannel, this.bufferSize, this.objectName);
            return this.parsingFunction.apply(params);
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

