/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphTouchFeature;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.UploadSession;
import org.nuxeo.onedrive.client.types.DriveItem;

public class GraphWriteFeature
implements Write<Void> {
    private static final Logger log = Logger.getLogger(GraphWriteFeature.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final GraphSession session;
    private final Find finder;
    private final AttributesFinder attributes;

    public GraphWriteFeature(GraphSession session) {
        this(session, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public GraphWriteFeature(GraphSession session, Find finder, AttributesFinder attributes) {
        this.session = session;
        this.finder = finder;
        this.attributes = attributes;
    }

    public HttpResponseOutputStream<Void> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            DriveItem folder = this.session.toFolder(file.getParent());
            DriveItem oneDriveFile = new DriveItem(folder, URIEncoder.encode((String)file.getName()));
            UploadSession upload = Files.createUploadSession((DriveItem)oneDriveFile);
            ChunkedOutputStream proxy = new ChunkedOutputStream(upload, file, status);
            int partsize = this.preferences.getInteger("onedrive.upload.multipart.partsize.minimum") * this.preferences.getInteger("onedrive.upload.multipart.partsize.factor");
            return new HttpResponseOutputStream<Void>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(partsize))){

                public Void getStatus() {
                    return null;
                }
            };
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService().map("Upload {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attributes = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attributes.getSize())).withChecksum(attributes.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    private final class ChunkedOutputStream
    extends OutputStream {
        private final UploadSession upload;
        private final Path file;
        private final TransferStatus overall;
        private final AtomicBoolean close = new AtomicBoolean();
        private Long offset = 0L;
        private final Long length;

        public ChunkedOutputStream(UploadSession upload, Path file, TransferStatus status) {
            this.upload = upload;
            this.file = file;
            this.overall = status;
            this.length = status.getOffset() + status.getLength();
        }

        @Override
        public void write(int b) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            final byte[] content = Arrays.copyOfRange(b, off, len);
            HttpRange range = HttpRange.byLength((long)this.offset, (long)content.length);
            final String header = this.overall.getLength() == -1L ? String.format("%d-%d/*", range.getStart(), range.getEnd()) : String.format("%d-%d/%d", range.getStart(), range.getEnd(), this.length);
            try {
                new DefaultRetryCallable(GraphWriteFeature.this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<Void>(){

                    public Void call() throws BackgroundException {
                        try {
                            if (ChunkedOutputStream.this.upload.uploadFragment(header, content) instanceof DriveItem.Metadata) {
                                log.info((Object)String.format("Completed upload for %s", ChunkedOutputStream.this.file));
                            } else {
                                log.debug((Object)String.format("Uploaded fragment %s for file %s", header, ChunkedOutputStream.this.file));
                            }
                        }
                        catch (OneDriveAPIException e) {
                            throw new GraphExceptionMappingService().map("Upload {0} failed", e, ChunkedOutputStream.this.file);
                        }
                        catch (IOException e) {
                            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, ChunkedOutputStream.this.file);
                        }
                        return null;
                    }
                }, (StreamCancelation)this.overall).call();
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
            this.offset = this.offset + (long)content.length;
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.close.get()) {
                    log.warn((Object)String.format("Skip double close of stream %s", this));
                    return;
                }
                if (0L == this.offset) {
                    log.warn((Object)String.format("Abort upload session %s with no completed parts", this.upload));
                    this.upload.cancelUpload();
                    new GraphTouchFeature(GraphWriteFeature.this.session).touch(this.file, new TransferStatus());
                }
            }
            catch (BackgroundException e) {
                throw new IOException(e);
            }
            finally {
                this.close.set(true);
            }
        }
    }
}

