/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.date.RFC1123DateFormatter;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.shared.DefaultTimestampFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import com.github.sardine.DavResource;
import com.github.sardine.impl.SardineException;
import com.github.sardine.util.SardineUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class DAVTimestampFeature
extends DefaultTimestampFeature
implements Timestamp {
    private final DAVSession session;
    public static final QName LAST_MODIFIED_DEFAULT_NAMESPACE = SardineUtil.createQNameWithDefaultNamespace((String)"lastmodified");
    public static final QName LAST_MODIFIED_CUSTOM_NAMESPACE = SardineUtil.createQNameWithCustomNamespace((String)"lastmodified");
    public static final QName LAST_MODIFIED_SERVER_CUSTOM_NAMESPACE = SardineUtil.createQNameWithCustomNamespace((String)"lastmodified_server");

    public DAVTimestampFeature(DAVSession session) {
        this.session = session;
    }

    public void setTimestamp(Path file, TransferStatus status) throws BackgroundException {
        try {
            List resources = ((DAVClient)((Object)this.session.getClient())).propfind(new DAVPathEncoder().encode(file), 0, Collections.singleton(SardineUtil.createQNameWithDefaultNamespace((String)"getlastmodified")));
            Iterator iterator = resources.iterator();
            if (iterator.hasNext()) {
                DavResource resource = (DavResource)iterator.next();
                ((DAVClient)((Object)this.session.getClient())).patch(new DAVPathEncoder().encode(file), this.getCustomProperties(resource, status.getTimestamp()), Collections.emptyList(), this.getCustomHeaders(file, status));
            }
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e, file);
        }
    }

    protected List<Element> getCustomProperties(DavResource resource, Long modified) {
        Element element;
        ArrayList<Element> props = new ArrayList<Element>();
        if (resource.getModified() != null) {
            element = SardineUtil.createElement((QName)LAST_MODIFIED_SERVER_CUSTOM_NAMESPACE);
            element.setTextContent(new RFC1123DateFormatter().format(resource.getModified(), TimeZone.getTimeZone("UTC")));
            props.add(element);
        }
        element = SardineUtil.createElement((QName)LAST_MODIFIED_CUSTOM_NAMESPACE);
        element.setTextContent(new RFC1123DateFormatter().format(modified.longValue(), TimeZone.getTimeZone("UTC")));
        props.add(element);
        return props;
    }

    protected Map<String, String> getCustomHeaders(Path file, TransferStatus status) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.session.getFeature(Lock.class) != null && status.getLockId() != null) {
            headers.put("If", String.format("(<%s>)", status.getLockId()));
        }
        return headers;
    }
}

