/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import java.io.IOException;

public class SwiftDefaultCopyFeature
implements Copy {
    private final PathContainerService containerService = new PathContainerService();
    private final SwiftSession session;
    private final SwiftRegionService regionService;

    public SwiftDefaultCopyFeature(SwiftSession session) {
        this(session, new SwiftRegionService(session));
    }

    public SwiftDefaultCopyFeature(SwiftSession session, SwiftRegionService regionService) {
        this.session = session;
        this.regionService = regionService;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            ((Client)this.session.getClient()).copyObject(this.regionService.lookup(source), this.containerService.getContainer(source).getName(), this.containerService.getKey(source), this.containerService.getContainer(target).getName(), this.containerService.getKey(target));
            return new Path(target.getParent(), target.getName(), target.getType(), new PathAttributes(source.attributes()));
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Cannot copy {0}", e, source);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot copy {0}", (Throwable)e, source);
        }
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source) && !this.containerService.isContainer(target);
    }
}

