/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import org.cryptomator.cryptolib.common.CipherSupplier;

public class AesKeyWrap {
    public static byte[] wrap(SecretKey kek, SecretKey key) {
        try {
            Cipher cipher = CipherSupplier.RFC3394_KEYWRAP.forWrapping(kek);
            return cipher.wrap(key);
        }
        catch (InvalidKeyException | IllegalBlockSizeException e) {
            throw new IllegalArgumentException("Unable to wrap key.", e);
        }
    }

    public static SecretKey unwrap(SecretKey kek, byte[] wrappedKey, String wrappedKeyAlgorithm) throws InvalidKeyException {
        return AesKeyWrap.unwrap(kek, wrappedKey, wrappedKeyAlgorithm, 3);
    }

    static SecretKey unwrap(SecretKey kek, byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException {
        Cipher cipher = CipherSupplier.RFC3394_KEYWRAP.forUnwrapping(kek);
        try {
            return (SecretKey)cipher.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Invalid algorithm: " + wrappedKeyAlgorithm, e);
        }
    }
}

