/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import org.bouncycastle.pqc.math.linearalgebra.GFElement;
import org.bouncycastle.util.Arrays;

public class GF2nONBElement
extends GF2nElement {
    private static final long[] mBitmask = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0x100000000L, 0x200000000L, 0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L, 0x40000000000L, 0x80000000000L, 0x100000000000L, 0x200000000000L, 0x400000000000L, 0x800000000000L, 0x1000000000000L, 0x2000000000000L, 0x4000000000000L, 0x8000000000000L, 0x10000000000000L, 0x20000000000000L, 0x40000000000000L, 0x80000000000000L, 0x100000000000000L, 0x200000000000000L, 0x400000000000000L, 0x800000000000000L, 0x1000000000000000L, 0x2000000000000000L, 0x4000000000000000L, Long.MIN_VALUE};
    private static final long[] mMaxmask = new long[]{1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE, -1L};
    private static final int[] mIBY64 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
    private static final int MAXLONG = 64;
    private int mLength;
    private int mBit;
    private long[] mPol;

    public GF2nONBElement(GF2nONBField gf2n, SecureRandom rand) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = new long[this.mLength];
        if (this.mLength > 1) {
            for (int j = 0; j < this.mLength - 1; ++j) {
                this.mPol[j] = rand.nextLong();
            }
            long last = rand.nextLong();
            this.mPol[this.mLength - 1] = last >>> 64 - this.mBit;
        } else {
            this.mPol[0] = rand.nextLong();
            this.mPol[0] = this.mPol[0] >>> 64 - this.mBit;
        }
    }

    public GF2nONBElement(GF2nONBField gf2n, byte[] e) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(e);
    }

    public GF2nONBElement(GF2nONBField gf2n, BigInteger val) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(val);
    }

    private GF2nONBElement(GF2nONBField gf2n, long[] val) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = val;
    }

    public GF2nONBElement(GF2nONBElement gf2n) {
        this.mField = gf2n.mField;
        this.mDegree = this.mField.getDegree();
        this.mLength = ((GF2nONBField)this.mField).getONBLength();
        this.mBit = ((GF2nONBField)this.mField).getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(gf2n.getElement());
    }

    public Object clone() {
        return new GF2nONBElement(this);
    }

    public static GF2nONBElement ZERO(GF2nONBField gf2n) {
        long[] polynomial = new long[gf2n.getONBLength()];
        return new GF2nONBElement(gf2n, polynomial);
    }

    public static GF2nONBElement ONE(GF2nONBField gf2n) {
        int mLength = gf2n.getONBLength();
        long[] polynomial = new long[mLength];
        for (int i = 0; i < mLength - 1; ++i) {
            polynomial[i] = -1L;
        }
        polynomial[mLength - 1] = mMaxmask[gf2n.getONBBit() - 1];
        return new GF2nONBElement(gf2n, polynomial);
    }

    void assignZero() {
        this.mPol = new long[this.mLength];
    }

    void assignOne() {
        for (int i = 0; i < this.mLength - 1; ++i) {
            this.mPol[i] = -1L;
        }
        this.mPol[this.mLength - 1] = mMaxmask[this.mBit - 1];
    }

    private void assign(BigInteger val) {
        this.assign(val.toByteArray());
    }

    private void assign(long[] val) {
        System.arraycopy(val, 0, this.mPol, 0, this.mLength);
    }

    private void assign(byte[] val) {
        this.mPol = new long[this.mLength];
        for (int j = 0; j < val.length; ++j) {
            int n = j >>> 3;
            this.mPol[n] = this.mPol[n] | ((long)val[val.length - 1 - j] & 0xFFL) << ((j & 7) << 3);
        }
    }

    public boolean isZero() {
        boolean result = true;
        for (int i = 0; i < this.mLength && result; ++i) {
            result = result && (this.mPol[i] & 0xFFFFFFFFFFFFFFFFL) == 0L;
        }
        return result;
    }

    public boolean isOne() {
        boolean result = true;
        for (int i = 0; i < this.mLength - 1 && result; ++i) {
            result = result && (this.mPol[i] & 0xFFFFFFFFFFFFFFFFL) == -1L;
        }
        if (result) {
            result = result && (this.mPol[this.mLength - 1] & mMaxmask[this.mBit - 1]) == mMaxmask[this.mBit - 1];
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof GF2nONBElement)) {
            return false;
        }
        GF2nONBElement otherElem = (GF2nONBElement)other;
        for (int i = 0; i < this.mLength; ++i) {
            if (this.mPol[i] == otherElem.mPol[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mPol);
    }

    public boolean testRightmostBit() {
        return (this.mPol[this.mLength - 1] & mBitmask[this.mBit - 1]) != 0L;
    }

    boolean testBit(int index) {
        if (index < 0 || index > this.mDegree) {
            return false;
        }
        long test = this.mPol[index >>> 6] & mBitmask[index & 0x3F];
        return test != 0L;
    }

    private long[] getElement() {
        long[] result = new long[this.mPol.length];
        System.arraycopy(this.mPol, 0, result, 0, this.mPol.length);
        return result;
    }

    private long[] getElementReverseOrder() {
        long[] result = new long[this.mPol.length];
        for (int i = 0; i < this.mDegree; ++i) {
            if (!this.testBit(this.mDegree - i - 1)) continue;
            int n = i >>> 6;
            result[n] = result[n] | mBitmask[i & 0x3F];
        }
        return result;
    }

    void reverseOrder() {
        this.mPol = this.getElementReverseOrder();
    }

    public GFElement add(GFElement addend) throws RuntimeException {
        GF2nONBElement result = new GF2nONBElement(this);
        result.addToThis(addend);
        return result;
    }

    public void addToThis(GFElement addend) throws RuntimeException {
        if (!(addend instanceof GF2nONBElement)) {
            throw new RuntimeException();
        }
        if (!this.mField.equals(((GF2nONBElement)addend).mField)) {
            throw new RuntimeException();
        }
        for (int i = 0; i < this.mLength; ++i) {
            int n = i;
            this.mPol[n] = this.mPol[n] ^ ((GF2nONBElement)addend).mPol[i];
        }
    }

    public GF2nElement increase() {
        GF2nONBElement result = new GF2nONBElement(this);
        result.increaseThis();
        return result;
    }

    public void increaseThis() {
        this.addToThis(GF2nONBElement.ONE((GF2nONBField)this.mField));
    }

    public GFElement multiply(GFElement factor) throws RuntimeException {
        GF2nONBElement result = new GF2nONBElement(this);
        result.multiplyThisBy(factor);
        return result;
    }

    public void multiplyThisBy(GFElement factor) throws RuntimeException {
        if (!(factor instanceof GF2nONBElement)) {
            throw new RuntimeException("The elements have different representation: not yet implemented");
        }
        if (!this.mField.equals(((GF2nONBElement)factor).mField)) {
            throw new RuntimeException();
        }
        if (this.equals(factor)) {
            this.squareThis();
        } else {
            long[] a = this.mPol;
            long[] b = ((GF2nONBElement)factor).mPol;
            long[] c = new long[this.mLength];
            int[][] m = ((GF2nONBField)this.mField).mMult;
            int degf = this.mLength - 1;
            int degb = this.mBit - 1;
            boolean s = false;
            long TWOTOMAXLONGM1 = mBitmask[63];
            long TWOTODEGB = mBitmask[degb];
            for (int k = 0; k < this.mDegree; ++k) {
                boolean old;
                int bita;
                int fielda;
                int i;
                s = false;
                for (i = 0; i < this.mDegree; ++i) {
                    fielda = mIBY64[i];
                    bita = i & 0x3F;
                    int fieldb = mIBY64[m[i][0]];
                    int bitb = m[i][0] & 0x3F;
                    if ((a[fielda] & mBitmask[bita]) == 0L) continue;
                    if ((b[fieldb] & mBitmask[bitb]) != 0L) {
                        s ^= true;
                    }
                    if (m[i][1] == -1 || (b[fieldb = mIBY64[m[i][1]]] & mBitmask[bitb = m[i][1] & 0x3F]) == 0L) continue;
                    s ^= true;
                }
                fielda = mIBY64[k];
                bita = k & 0x3F;
                if (s) {
                    int n = fielda;
                    c[n] = c[n] ^ mBitmask[bita];
                }
                if (this.mLength > 1) {
                    boolean now;
                    old = (a[degf] & 1L) == 1L;
                    for (i = degf - 1; i >= 0; --i) {
                        now = (a[i] & 1L) != 0L;
                        a[i] = a[i] >>> 1;
                        if (old) {
                            int n = i;
                            a[n] = a[n] ^ TWOTOMAXLONGM1;
                        }
                        old = now;
                    }
                    a[degf] = a[degf] >>> 1;
                    if (old) {
                        int n = degf;
                        a[n] = a[n] ^ TWOTODEGB;
                    }
                    old = (b[degf] & 1L) == 1L;
                    for (i = degf - 1; i >= 0; --i) {
                        now = (b[i] & 1L) != 0L;
                        b[i] = b[i] >>> 1;
                        if (old) {
                            int n = i;
                            b[n] = b[n] ^ TWOTOMAXLONGM1;
                        }
                        old = now;
                    }
                    b[degf] = b[degf] >>> 1;
                    if (!old) continue;
                    int n = degf;
                    b[n] = b[n] ^ TWOTODEGB;
                    continue;
                }
                old = (a[0] & 1L) == 1L;
                a[0] = a[0] >>> 1;
                if (old) {
                    a[0] = a[0] ^ TWOTODEGB;
                }
                old = (b[0] & 1L) == 1L;
                b[0] = b[0] >>> 1;
                if (!old) continue;
                b[0] = b[0] ^ TWOTODEGB;
            }
            this.assign(c);
        }
    }

    public GF2nElement square() {
        GF2nONBElement result = new GF2nONBElement(this);
        result.squareThis();
        return result;
    }

    public void squareThis() {
        boolean now;
        long[] pol = this.getElement();
        int f = this.mLength - 1;
        int b = this.mBit - 1;
        long TWOTOMAXLONGM1 = mBitmask[63];
        boolean old = (pol[f] & mBitmask[b]) != 0L;
        for (int i = 0; i < f; ++i) {
            now = (pol[i] & TWOTOMAXLONGM1) != 0L;
            pol[i] = pol[i] << 1;
            if (old) {
                int n = i;
                pol[n] = pol[n] ^ 1L;
            }
            old = now;
        }
        now = (pol[f] & mBitmask[b]) != 0L;
        pol[f] = pol[f] << 1;
        if (old) {
            int n = f;
            pol[n] = pol[n] ^ 1L;
        }
        if (now) {
            int n = f;
            pol[n] = pol[n] ^ mBitmask[b + 1];
        }
        this.assign(pol);
    }

    public GFElement invert() throws ArithmeticException {
        GF2nONBElement result = new GF2nONBElement(this);
        result.invertThis();
        return result;
    }

    public void invertThis() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        boolean found = false;
        for (int r = 31; !found && r >= 0; --r) {
            if (((long)(this.mDegree - 1) & mBitmask[r]) == 0L) continue;
            found = true;
        }
        GF2nElement m = GF2nONBElement.ZERO((GF2nONBField)this.mField);
        GF2nONBElement n = new GF2nONBElement(this);
        int k = 1;
        for (int i = ++r - 1; i >= 0; --i) {
            m = (GF2nElement)((GF2nElement)n).clone();
            for (int j = 1; j <= k; ++j) {
                m.squareThis();
            }
            n.multiplyThisBy(m);
            k <<= 1;
            if (((long)(this.mDegree - 1) & mBitmask[i]) == 0L) continue;
            ((GF2nElement)n).squareThis();
            n.multiplyThisBy(this);
            ++k;
        }
        ((GF2nElement)n).squareThis();
    }

    public GF2nElement squareRoot() {
        GF2nONBElement result = new GF2nONBElement(this);
        result.squareRootThis();
        return result;
    }

    public void squareRootThis() {
        long[] pol = this.getElement();
        int f = this.mLength - 1;
        int b = this.mBit - 1;
        long TWOTOMAXLONGM1 = mBitmask[63];
        boolean old = (pol[0] & 1L) != 0L;
        for (int i = f; i >= 0; --i) {
            boolean now = (pol[i] & 1L) != 0L;
            pol[i] = pol[i] >>> 1;
            if (old) {
                if (i == f) {
                    int n = i;
                    pol[n] = pol[n] ^ mBitmask[b];
                } else {
                    int n = i;
                    pol[n] = pol[n] ^ TWOTOMAXLONGM1;
                }
            }
            old = now;
        }
        this.assign(pol);
    }

    public int trace() {
        int j;
        int result = 0;
        int max = this.mLength - 1;
        for (int i = 0; i < max; ++i) {
            for (j = 0; j < 64; ++j) {
                if ((this.mPol[i] & mBitmask[j]) == 0L) continue;
                result ^= 1;
            }
        }
        int b = this.mBit;
        for (j = 0; j < b; ++j) {
            if ((this.mPol[max] & mBitmask[j]) == 0L) continue;
            result ^= 1;
        }
        return result;
    }

    public GF2nElement solveQuadraticEquation() throws RuntimeException {
        if (this.trace() == 1) {
            throw new RuntimeException();
        }
        long TWOTOMAXLONGM1 = mBitmask[63];
        long ZERO = 0L;
        long ONE = 1L;
        long[] p = new long[this.mLength];
        long z = 0L;
        int j = 1;
        for (int i = 0; i < this.mLength - 1; ++i) {
            for (j = 1; j < 64; ++j) {
                if ((mBitmask[j] & this.mPol[i]) != ZERO && (z & mBitmask[j - 1]) != ZERO || (this.mPol[i] & mBitmask[j]) == ZERO && (z & mBitmask[j - 1]) == ZERO) continue;
                z ^= mBitmask[j];
            }
            p[i] = z;
            z = (TWOTOMAXLONGM1 & z) != ZERO && (ONE & this.mPol[i + 1]) == ONE || (TWOTOMAXLONGM1 & z) == ZERO && (ONE & this.mPol[i + 1]) == ZERO ? ZERO : ONE;
        }
        int b = this.mDegree & 0x3F;
        long LASTLONG = this.mPol[this.mLength - 1];
        for (j = 1; j < b; ++j) {
            if ((mBitmask[j] & LASTLONG) != ZERO && (mBitmask[j - 1] & z) != ZERO || (mBitmask[j] & LASTLONG) == ZERO && (mBitmask[j - 1] & z) == ZERO) continue;
            z ^= mBitmask[j];
        }
        p[this.mLength - 1] = z;
        return new GF2nONBElement((GF2nONBField)this.mField, p);
    }

    public String toString() {
        return this.toString(16);
    }

    public String toString(int radix) {
        String s;
        block5: {
            long[] a;
            block4: {
                s = "";
                a = this.getElement();
                int b = this.mBit;
                if (radix != 2) break block4;
                for (int j = b - 1; j >= 0; --j) {
                    s = (a[a.length - 1] & 1L << j) == 0L ? s + "0" : s + "1";
                }
                for (int i = a.length - 2; i >= 0; --i) {
                    for (int j = 63; j >= 0; --j) {
                        s = (a[i] & mBitmask[j]) == 0L ? s + "0" : s + "1";
                    }
                }
                break block5;
            }
            if (radix != 16) break block5;
            char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            for (int i = a.length - 1; i >= 0; --i) {
                s = s + HEX_CHARS[(int)(a[i] >>> 60) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 56) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 52) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 48) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 44) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 40) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 36) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 32) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 28) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 24) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 20) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 16) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 12) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 8) & 0xF];
                s = s + HEX_CHARS[(int)(a[i] >>> 4) & 0xF];
                s = s + HEX_CHARS[(int)a[i] & 0xF];
                s = s + " ";
            }
        }
        return s;
    }

    public BigInteger toFlexiBigInt() {
        return new BigInteger(1, this.toByteArray());
    }

    public byte[] toByteArray() {
        int k = (this.mDegree - 1 >> 3) + 1;
        byte[] result = new byte[k];
        for (int i = 0; i < k; ++i) {
            result[k - i - 1] = (byte)((this.mPol[i >>> 3] & 255L << ((i & 7) << 3)) >>> ((i & 7) << 3));
        }
        return result;
    }
}

