/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.TranscriptListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPCmd;

public class LoggingProtocolCommandListener
implements ProtocolCommandListener,
TranscriptListener {
    private final TranscriptListener transcript;

    protected LoggingProtocolCommandListener(TranscriptListener transcript) {
        this.transcript = transcript;
    }

    public void protocolCommandSent(ProtocolCommandEvent event) {
        String message = StringUtils.chomp((String)event.getMessage());
        if (message.startsWith(FTPCmd.PASS.name())) {
            this.log(TranscriptListener.Type.request, String.format("%s %s", FTPCmd.PASS.name(), StringUtils.repeat((String)"*", (int)StringUtils.length((CharSequence)StringUtils.removeStart((String)message, (String)FTPCmd.PASS.name())))));
        } else {
            this.log(TranscriptListener.Type.request, message);
        }
    }

    public void protocolReplyReceived(ProtocolCommandEvent event) {
        this.log(TranscriptListener.Type.response, StringUtils.chomp((String)event.getMessage()));
    }

    public void log(TranscriptListener.Type request, String event) {
        this.transcript.log(request, event);
    }
}

